/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.servlet;

import com.mingsoft.basic.biz.IAppBiz;
import com.mingsoft.basic.entity.AppEntity;
import com.mingsoft.basic.servlet.BaseServlet;
import com.mingsoft.util.StringUtil;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(value={"/index"})
public class IndexServlet
extends BaseServlet {
    private static final long serialVersionUID = -7580260477467138079L;
    private static String INDEX = "index.html";
    private static String DEFAULT = "default.html";
    private IAppBiz appBiz;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.appBiz = (IAppBiz)this.getBean(request.getServletContext(), "appBiz");
        int websiteId = 0;
        AppEntity website = this.appBiz.getByUrl(this.getDomain(request));
        if (website == null) {
            this.outString(response, this.getResString("err.not.exist", this.getDomain(request)));
            return;
        }
        websiteId = website.getAppId();
        String path = "";
        if (!StringUtil.isBlank((String)website.getAppMobileStyle())) {
            path = this.isMobileDevice(request) ? "m" : "";
        }
        String defaultHtmlPath = this.getRealPath(request, "html" + File.separator + websiteId + File.separator + path + File.separator + "default.html");
        File file = new File(defaultHtmlPath);
        String url = "html/" + websiteId + "/" + path;
        String indexPosition = String.valueOf(url) + "/" + INDEX;
        if (file.exists()) {
            indexPosition = String.valueOf(url) + "/" + DEFAULT;
        }
        request.getRequestDispatcher(indexPosition).forward((ServletRequest)request, (ServletResponse)response);
    }
}

