/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.interceptor;

import com.mingsoft.base.constant.e.BaseCookieEnum;
import com.mingsoft.base.constant.e.BaseSessionEnum;
import com.mingsoft.basic.biz.IAppBiz;
import com.mingsoft.basic.entity.AppEntity;
import com.mingsoft.util.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public abstract class BaseInterceptor
extends HandlerInterceptorAdapter {
    protected static String BASE = "base";
    protected static String BASE_PATH = "basePath";
    protected static String MODEL_ID = "modelId";
    protected static String BASE_URL = "baseUrl";
    protected static String BASE_MANAGER_PATH = "baseManager";
    protected static String MANAGER_PATH = "managerPath";
    protected Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    protected static boolean IS_WINDOWS = false;

    static {
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") > 0) {
            IS_WINDOWS = true;
        }
    }

    protected Object getBean(ServletContext sc, String beanName) {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc).getBean(beanName);
    }

    protected void setSession(HttpServletRequest request, BaseSessionEnum key, Object obj) {
        if (StringUtil.isBlank((String)obj.toString())) {
            return;
        }
        request.getSession().setAttribute(key.toString(), obj);
    }

    protected Object getSession(HttpServletRequest request, BaseSessionEnum key) {
        return request.getSession().getAttribute(key.toString());
    }

    protected void setCookie(HttpServletRequest request, HttpServletResponse response, BaseCookieEnum key, Object value) {
        request.getSession().setAttribute(key.toString(), value);
        Cookie cookie = new Cookie(key.toString(), (String)value);
        cookie.setPath("/");
        cookie.setValue((String)value);
        response.addCookie(cookie);
    }

    protected void setCookie(HttpServletRequest request, HttpServletResponse response, BaseCookieEnum key, Object value, int maxAge) {
        request.getSession().setAttribute(key.toString(), value);
        Cookie cookie = new Cookie(key.toString(), value.toString());
        cookie.setPath("/");
        cookie.setValue(value.toString());
        cookie.setMaxAge(maxAge);
        response.addCookie(cookie);
    }

    protected String getCookie(HttpServletRequest request, BaseCookieEnum key) {
        if (request.getCookies() != null) {
            Cookie[] cookieArray = request.getCookies();
            int n = cookieArray.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie c = cookieArray[n2];
                System.out.println(String.valueOf(c.getName()) + ":" + c.getValue());
                if (c.getName().equals(key.toString())) {
                    return c.getValue();
                }
                ++n2;
            }
        }
        return null;
    }

    protected void outJson(HttpServletResponse response, Object jsonDataStr) {
        try {
            response.setContentType("application/json;charset=utf-8");
            PrintWriter out = response.getWriter();
            out.print(jsonDataStr);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected int getAppId(HttpServletRequest request) {
        return this.getApp(request).getAppId();
    }

    protected AppEntity getApp(HttpServletRequest request) {
        AppEntity app = new AppEntity();
        IAppBiz appBiz = (IAppBiz)this.getBean(request.getServletContext(), "appBiz");
        AppEntity website = appBiz.getByUrl(this.getDomain(request));
        if (website == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)((Object)website), (Object)((Object)app));
        return app;
    }

    private String getDomain(HttpServletRequest request) {
        String path = request.getContextPath();
        String domain = request.getServerName();
        domain = request.getServerPort() == 80 ? String.valueOf(domain) + path : String.valueOf(domain) + ":" + request.getServerPort() + path;
        return domain;
    }
}

