/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.biz.impl;

import com.mingsoft.base.dao.IBaseDao;
import com.mingsoft.basic.biz.IColumnBiz;
import com.mingsoft.basic.biz.impl.CategoryBizImpl;
import com.mingsoft.basic.dao.IColumnDao;
import com.mingsoft.basic.entity.BasicEntity;
import com.mingsoft.basic.entity.ColumnEntity;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="columnBiz")
public class ColumnBizImpl
extends CategoryBizImpl
implements IColumnBiz {
    private IColumnDao columnDao;

    public IColumnDao getColumnDao() {
        return this.columnDao;
    }

    @Autowired
    public void setColumnDao(IColumnDao columnDao) {
        this.columnDao = columnDao;
    }

    @Override
    protected IBaseDao getDao() {
        return this.columnDao;
    }

    @Override
    public List<ColumnEntity> queryColumnListByWebsiteId(int columnWebsiteId) {
        return this.columnDao.queryColumnListByWebsiteId(columnWebsiteId);
    }

    @Override
    public List<ColumnEntity> queryChild(int categoryCategoryId, int columnWebsiteId, Integer modelId, Integer size) {
        return this.columnDao.queryColumnByCategoryIdAndWebsiteIdAndModelId(categoryCategoryId, columnWebsiteId, modelId, size);
    }

    @Override
    public List<ColumnEntity> queryAll(int appId, int modelId) {
        return this.columnDao.queryByAppIdAndModelId(appId, modelId);
    }

    @Override
    public List<ColumnEntity> queryColumnChildListRecursionByWebsiteId(int categoryId, int columnWebsiteId) {
        ArrayList<ColumnEntity> list = new ArrayList<ColumnEntity>();
        ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(categoryId);
        if (columnEntity != null) {
            int categoryCategoryId = columnEntity.getCategoryCategoryId();
            this.queryExpansionColumnListByWebsiteId(categoryCategoryId, list, columnWebsiteId);
        }
        return list;
    }

    private void queryExpansionColumnListByWebsiteId(int categoryCategoryId, List<ColumnEntity> list, int columnWebsiteId) {
        List<Object> queryChildList = new ArrayList();
        queryChildList = this.columnDao.queryColumnByCategoryIdAndWebsiteIdAndModelId(categoryCategoryId, columnWebsiteId, null, null);
        int i = 0;
        while (i < queryChildList.size()) {
            list.add((ColumnEntity)((Object)queryChildList.get(i)));
            ++i;
        }
        if (categoryCategoryId != 0) {
            ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(categoryCategoryId);
            this.queryExpansionColumnListByWebsiteId(columnEntity.getCategoryCategoryId(), list, columnWebsiteId);
        }
    }

    @Override
    public List<ColumnEntity> querySibling(int columnId, Integer size) {
        ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(columnId);
        List<ColumnEntity> list = new ArrayList<ColumnEntity>();
        if (columnEntity != null) {
            list = this.columnDao.queryColumnByCategoryIdAndWebsiteIdAndModelId(columnEntity.getCategoryCategoryId(), columnEntity.getColumnWebsiteId(), null, size);
        }
        return list;
    }

    @Override
    public List<ColumnEntity> queryTopSiblingListByColumnId(int columnId, Integer size) {
        ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(columnId);
        List<ColumnEntity> list = null;
        if (columnEntity != null) {
            list = this.querySibling(columnEntity.getCategoryCategoryId(), size);
        }
        return list;
    }

    @Override
    public List<ColumnEntity> queryChildListByColumnId(int columnId, Integer size) {
        ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(columnId);
        List<ColumnEntity> list = null;
        if (columnEntity != null) {
            list = this.columnDao.queryColumnByCategoryIdAndWebsiteIdAndModelId(columnEntity.getCategoryId(), columnEntity.getColumnWebsiteId(), null, size);
        }
        return list;
    }

    @Override
    public List<Integer> queryChildIdsByColumnId(int categoryId, int appId) {
        ArrayList<Integer> list = new ArrayList();
        list = this.columnDao.queryColumnChildIdList(categoryId, appId);
        return list;
    }

    @Override
    public List<ColumnEntity> queryColumnListBycolumnType(int columnType, int columnWebsiteId) {
        return this.columnDao.queryColumnListBycolumnType(columnType, columnWebsiteId);
    }

    private void queryColumnParent(ColumnEntity column, List<ColumnEntity> list) {
        if (column.getCategoryCategoryId() != 0) {
            ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(column.getCategoryCategoryId());
            list.add(columnEntity);
            this.queryColumnParent(columnEntity, list);
        }
    }

    @Override
    public List<ColumnEntity> queryParentColumnByColumnId(int columnId) {
        ArrayList<ColumnEntity> list = null;
        ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(columnId);
        if (columnEntity != null) {
            list = new ArrayList<ColumnEntity>();
            this.queryColumnParent(columnEntity, list);
        }
        return list;
    }

    @Override
    public int queryColumnChildListCountByWebsiteId(int categoryCategoryId, int columnWebsiteId) {
        return this.columnDao.queryColumnChildListCountByWebsiteId(categoryCategoryId, columnWebsiteId);
    }

    @Override
    public List<BasicEntity> queryCategoryByManagerIdAndModelId(int categoryManagerId, int categoryModelId) {
        return this.columnDao.queryCategoryByManagerIdAndModelId(categoryManagerId, categoryModelId);
    }

    @Override
    public List<ColumnEntity> querSibListByColumnId(int columnId) {
        ColumnEntity columnEntity = (ColumnEntity)this.columnDao.getEntity(columnId);
        List<ColumnEntity> list = null;
        if (columnEntity != null && columnEntity.getCategoryId() != 0) {
            list = this.columnDao.queryColumnByCategoryIdAndWebsiteIdAndModelId(columnEntity.getCategoryId(), columnEntity.getColumnWebsiteId(), null, null);
        }
        return list;
    }
}

