/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.IAppBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.constant.e.CookieConstEnum;
import com.mingsoft.basic.entity.AppEntity;
import com.mingsoft.basic.entity.ManagerSessionEntity;
import com.mingsoft.util.FileUtil;
import com.mingsoft.util.PageUtil;
import com.mingsoft.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/manager/template"})
public class TemplateAction
extends BaseAction {
    @Autowired
    private IAppBiz appBiz;
    private static final String SKINLIST_PAGE_URL = "/manager/template/queryTemplateSkin.do";

    @RequestMapping(value={"/queryAppTemplateSkin"})
    @ResponseBody
    public Map queryAppTemplateSkin(HttpServletRequest request) {
        List<String> folderNameList = this.queryTemplateFile(request);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (!StringUtil.isBlank(folderNameList)) {
            map.put("fileName", folderNameList);
        }
        return map;
    }

    @RequestMapping(value={"/queryTemplateFileForColumn"})
    @ResponseBody
    public List<String> queryTemplateFileForColumn(HttpServletRequest request) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        String path = String.valueOf(this.getRealPath(request, "templets")) + File.separator + managerSession.getBasicId();
        int websiteId = managerSession.getBasicId();
        AppEntity website = (AppEntity)this.appBiz.getEntity(websiteId);
        path = String.valueOf(path) + File.separator + website.getAppStyle();
        this.LOG.debug((Object)("tempPath:" + path));
        ArrayList<String> listName = new ArrayList<String>();
        File fileDir = new File(path);
        if (fileDir.isDirectory()) {
            File[] files = fileDir.listFiles();
            int i = 0;
            while (i < files.length) {
                File currFile = files[i];
                if (currFile.isFile()) {
                    String ex = currFile.getName().substring(currFile.getName().indexOf(".") + 1);
                    if (ex.equals("htm") || ex.equals("html")) {
                        listName.add(currFile.getName());
                    }
                } else if (currFile.isDirectory()) {
                    File[] _files = currFile.listFiles();
                    int k = 0;
                    while (k < _files.length) {
                        String ex;
                        File _currFile = _files[k];
                        if (_currFile.isFile() && ((ex = _currFile.getName().substring(_currFile.getName().indexOf(".") + 1)).equals("htm") || ex.equals("html"))) {
                            listName.add(String.valueOf(currFile.getName()) + File.separator + _currFile.getName());
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        return listName;
    }

    @RequestMapping(value={"/queryTemplateSkin"})
    protected String queryTemplateSkin(HttpServletResponse response, ModelMap model, HttpServletRequest request) {
        String pageNo = request.getParameter("pageNo");
        if (!StringUtil.isInteger((String)pageNo)) {
            pageNo = "1";
        }
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        List<String> folderNameList = this.queryTemplateFile(request);
        model.addAttribute("folderNameList", folderNameList);
        model.addAttribute("websiteId", (Object)managerSession.getBasicId());
        int recordCount = 0;
        if (!StringUtil.isBlank(folderNameList)) {
            recordCount = folderNameList.size();
        }
        PageUtil page = new PageUtil(StringUtil.string2Int((String)pageNo), recordCount, String.valueOf(this.getUrl(request)) + SKINLIST_PAGE_URL);
        this.setCookie(request, response, CookieConstEnum.PAGENO_COOKIE, pageNo);
        model.addAttribute("page", (Object)page);
        return "/manager/template/template_list";
    }

    @RequestMapping(value={"/unZip"})
    @ResponseBody
    public String unZip(ModelMap model, HttpServletRequest request) throws ZipException, IOException {
        String entryName = "";
        String fileUrl = request.getParameter("fileUrl");
        File file = new File(this.getRealPath(request, fileUrl));
        ZipFile zipFile = new ZipFile(file);
        File unzipFile = new File(this.getRealPath(request, fileUrl.substring(0, fileUrl.length() - file.getName().length())));
        Enumeration<? extends ZipEntry> zipEnum = zipFile.entries();
        while (zipEnum.hasMoreElements()) {
            ZipEntry entry = zipEnum.nextElement();
            entryName = new String(entry.getName().getBytes("utf-8"));
            if (entry.isDirectory()) {
                new File(String.valueOf(unzipFile.getAbsolutePath()) + File.separator + entryName).mkdirs();
                continue;
            }
            InputStream input = zipFile.getInputStream(entry);
            FileOutputStream output = new FileOutputStream(new File(String.valueOf(unzipFile.getAbsolutePath()) + File.separator + entryName));
            byte[] buffer = new byte[8192];
            int readLen = 0;
            while ((readLen = input.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)output).write(buffer, 0, readLen);
            }
            output.flush();
            ((OutputStream)output).close();
            input.close();
            input = null;
            output = null;
        }
        zipFile.close();
        return entryName;
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public boolean delete(HttpServletRequest request) {
        String fileName = request.getParameter("fileName");
        String path = this.getRealPath(request, "templets" + File.separator + this.getAppId(request) + File.separator + fileName);
        try {
            FileUtil.delFolders((String)path);
            FileUtil.delFile((String)path);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String getTemplateUrl(HttpServletRequest request, String fileNameUrl) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        String templetsUrl = this.getRealPath(request, "templets" + File.separator + managerSession.getBasicId() + File.separator + fileNameUrl);
        return templetsUrl;
    }

    @RequestMapping(value={"/showChildFileAndFolder"})
    public String showChildFileAndFolder(HttpServletResponse response, ModelMap model, HttpServletRequest request) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        ArrayList<String> folderNameList = null;
        String skinFolderName = request.getParameter("skinFolderName");
        File[] files = new File(this.getRealPath(request, skinFolderName)).listFiles();
        if (!StringUtil.isBlank((Object)files)) {
            folderNameList = new ArrayList<String>();
            ArrayList<String> fileNameList = new ArrayList<String>();
            int i = 0;
            while (i < files.length) {
                File currFile = files[i];
                String filter = "templets/" + this.getAppId(request) + "/";
                String temp = currFile.getPath().replace(this.getRealPath(request, ""), "").replace(filter, "");
                filter = "templets\\" + this.getAppId(request) + "\\";
                temp = temp.replace(filter, "");
                if (currFile.isDirectory()) {
                    folderNameList.add(temp);
                } else {
                    fileNameList.add(temp);
                }
                ++i;
            }
            folderNameList.addAll(fileNameList);
            model.addAttribute("fileNameList", folderNameList);
        }
        String uploadFileUrl = skinFolderName;
        model.addAttribute("uploadFileUrl", (Object)(String.valueOf(uploadFileUrl) + File.separator));
        model.addAttribute("websiteId", (Object)managerSession.getBasicId());
        return "/manager/template/template_file_list";
    }

    @RequestMapping(value={"/readFileContent"})
    public String readFileContent(ModelMap model, HttpServletRequest request) {
        String fileName = request.getParameter("fileName");
        if (!StringUtil.isBlank((String)fileName)) {
            model.addAttribute("fileContent", (Object)FileUtil.readFile((String)this.getRealPath(request, fileName)));
        }
        model.addAttribute("name", (Object)new File(this.getRealPath(request, fileName)).getName());
        model.addAttribute("fileName", (Object)fileName);
        model.addAttribute("fileNamePrefix", (Object)fileName.substring(0, fileName.lastIndexOf(File.separator) + 1));
        return "/manager/template/template_edit_file";
    }

    @RequestMapping(value={"/deleteTemplateFile"})
    @ResponseBody
    public int deleteTemplateFile(HttpServletRequest request) {
        int pageNo = 1;
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        String fileName = request.getParameter("fileName");
        FileUtil.delFile((String)this.getRealPath(request, "templets" + File.separator + managerSession.getBasicId() + File.separator + fileName));
        this.getHistoryPageNoByCookie(request);
        return pageNo;
    }

    @RequestMapping(value={"/writeFileContent"})
    public void writeFileContent(ModelMap model, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String fileName = request.getParameter("fileName");
        String oldFileName = request.getParameter("oldFileName");
        String fileContent = request.getParameter("fileContent");
        this.getManagerBySession(request);
        if (!StringUtil.isBlank((String)fileName)) {
            String templets = this.getRealPath(request, fileName);
            this.LOG.debug((Object)templets);
            FileUtil.writeFile((String)fileContent, (String)templets, (String)"utf-8");
            if (!fileName.equals(oldFileName)) {
                File newName = new File(templets);
                File oldName = new File(this.getRealPath(request, oldFileName));
                oldName.renameTo(newName);
                FileUtil.delFile((String)this.getRealPath(request, oldFileName));
            }
            this.outJson(response, ModelCode.ROLE, true, null);
        }
    }

    private List<String> queryTemplateFile(HttpServletRequest request) {
        String templets;
        File file;
        String[] str;
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        ArrayList<String> folderNameList = null;
        if (!this.isSystemManager(request) && !StringUtil.isBlank((String[])(str = (file = new File(templets = this.getRealPath(request, "templets" + File.separator + managerSession.getBasicId() + File.separator))).list()))) {
            folderNameList = new ArrayList<String>();
            int i = 0;
            while (i < str.length) {
                if (str[i].indexOf(".") < 0) {
                    folderNameList.add(str[i]);
                }
                ++i;
            }
        }
        return folderNameList;
    }
}

