/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.alibaba.fastjson.JSONObject;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.IManagerBiz;
import com.mingsoft.basic.biz.IModelBiz;
import com.mingsoft.basic.biz.IRoleBiz;
import com.mingsoft.basic.biz.IRoleModelBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.constant.e.CookieConstEnum;
import com.mingsoft.basic.entity.ManagerSessionEntity;
import com.mingsoft.basic.entity.RoleEntity;
import com.mingsoft.basic.entity.RoleModelEntity;
import com.mingsoft.util.PageUtil;
import com.mingsoft.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/manager/role"})
public class RoleAction
extends BaseAction {
    @Autowired
    private IRoleBiz roleBiz;
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IManagerBiz managerBiz;
    @Autowired
    private IRoleModelBiz roleModelBiz;
    private static final String PAGE_URL = "/manager/role/queryList.do";

    @RequestMapping(value={"/queryList"})
    public String queryList(HttpServletRequest request, ModelMap mode, HttpServletResponse response) {
        List<Object> listRole = new ArrayList();
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        String pageNo = request.getParameter("pageNo");
        if (!StringUtil.isInteger((String)pageNo)) {
            pageNo = "1";
        }
        int recordCount = this.roleBiz.getCountByManagerId(managerSession.getManagerId());
        PageUtil page = new PageUtil(StringUtil.string2Int((String)pageNo), recordCount, String.valueOf(this.getUrl(request)) + PAGE_URL);
        this.setCookie(request, response, CookieConstEnum.PAGENO_COOKIE, pageNo);
        String url = PAGE_URL;
        this.setCookie(request, response, CookieConstEnum.BACK_COOKIE, String.valueOf(url) + "?pageNo=" + pageNo);
        listRole = this.roleBiz.queryByPage(managerSession.getManagerId(), page, "ROLE_ID", false);
        mode.addAttribute("listRole", listRole);
        mode.addAttribute("page", (Object)page);
        mode.addAttribute("managerRoleId", (Object)managerSession.getManagerRoleID());
        return "/manager/role/role_list";
    }

    public void queryModelList(HttpServletRequest request, ModelMap model) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        List<BaseEntity> listModel = this.modelBiz.queryModelByRoleId(managerSession.getManagerRoleID());
        if (!StringUtil.isBlank(listModel)) {
            model.addAttribute("listModel", (Object)JSONObject.toJSONString(listModel));
        }
    }

    @RequestMapping(value={"/{roleId}/queryByRole"})
    @ResponseBody
    public void queryByRole(@PathVariable int roleId, HttpServletResponse response) {
        List<BaseEntity> models = this.modelBiz.queryModelByRoleId(roleId);
        this.outJson(response, JSONObject.toJSONString(models));
    }

    @RequestMapping(value={"/add"})
    public String add(HttpServletRequest request, ModelMap model) {
        this.queryModelList(request, model);
        model.addAttribute("flag", (Object)true);
        return "/manager/role/role";
    }

    @RequestMapping(value={"/{roleId}/edit"})
    public String edit(@PathVariable int roleId, ModelMap model, HttpServletRequest request) {
        if (roleId == 0) {
            return "/manager/role/list";
        }
        this.queryModelList(request, model);
        RoleEntity role = (RoleEntity)this.roleBiz.getEntity(roleId);
        List<BaseEntity> listSelModel = this.modelBiz.queryModelByRoleId(roleId);
        model.addAttribute("role", (Object)role);
        if (!StringUtil.isBlank(listSelModel)) {
            model.addAttribute("listSelModel", listSelModel);
        }
        model.addAttribute("flag", (Object)false);
        return "/manager/role/role";
    }

    public boolean validateForm(RoleEntity role, HttpServletResponse response) {
        if (!StringUtil.checkLength((String)role.getRoleName(), (int)2, (int)8)) {
            this.outJson(response, ModelCode.ROLE, false, this.getResString("err.length", new String[]{this.getResString("rolrName"), "2", "8"}));
            return false;
        }
        if (this.roleBiz.countRoleName(role.getRoleName(), role.getRoleManagerId()) != 0) {
            this.outJson(response, ModelCode.ROLE, false, this.getResString("err.exist", new String[]{this.getResString("rolrName")}));
            return false;
        }
        return true;
    }

    public void saveOrUpdateRole(RoleEntity role, HttpServletRequest request, HttpServletResponse response, boolean flag) {
        if (!this.validateForm(role, response)) {
            return;
        }
        if (!flag && this.roleBiz.countRoleName(role.getRoleName(), role.getRoleManagerId()) != 0 && !role.getRoleName().equals(request.getParameter("oldRoleName"))) {
            this.outJson(response, ModelCode.ROLE, false, this.getResString("roleName.exist"));
            return;
        }
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        role.setRoleManagerId(managerSession.getManagerId());
        if (flag) {
            this.roleBiz.saveEntity(role);
        } else {
            this.roleBiz.updateEntity(role);
        }
        ArrayList<RoleModelEntity> roleModelList = null;
        String[] modelId = request.getParameterValues("modelId");
        if (!StringUtil.isBlank((String[])modelId)) {
            modelId = modelId[0].split(",");
        }
        if (StringUtil.isBlank((String)modelId[0])) {
            this.roleModelBiz.deleteEntity(role.getRoleId());
            this.outJson(response, ModelCode.ROLE, false, this.getResString("err.modelNoSelected"));
            return;
        }
        roleModelList = new ArrayList<RoleModelEntity>();
        int i = 0;
        while (i < modelId.length) {
            RoleModelEntity roleModel = new RoleModelEntity();
            roleModel.setModelId(Integer.parseInt(modelId[i]));
            roleModel.setRoleId(this.roleBiz.queryRoleByRoleName(role.getRoleName(), role.getRoleManagerId()).getRoleId());
            roleModelList.add(roleModel);
            ++i;
        }
        if (flag) {
            this.roleModelBiz.saveEntity(roleModelList);
        } else {
            this.roleModelBiz.deleteEntity(role.getRoleId());
            this.roleModelBiz.updateEntity(roleModelList);
        }
        String url = this.getCookie(request, CookieConstEnum.BACK_COOKIE);
        this.outJson(response, ModelCode.ROLE, true, url);
    }

    @RequestMapping(value={"/save"})
    public void save(@ModelAttribute RoleEntity role, HttpServletRequest request, HttpServletResponse response) {
        this.saveOrUpdateRole(role, request, response, true);
    }

    @RequestMapping(value={"/update"})
    public void update(@ModelAttribute RoleEntity role, HttpServletRequest request, HttpServletResponse response) {
        this.saveOrUpdateRole(role, request, response, false);
    }

    @RequestMapping(value={"/judgeRoleNameExist"})
    @ResponseBody
    public boolean judgeRoleNameExist(@RequestParam(value="roleName") String roleName, HttpServletRequest request) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        return this.roleBiz.countRoleName(roleName, managerSession.getManagerId()) != 0;
    }

    @RequestMapping(value={"/{roleId}/delete"})
    @ResponseBody
    public int delete(@PathVariable int roleId, HttpServletRequest request) {
        int pageNo = 1;
        if (roleId != 0) {
            this.managerBiz.deleteManagerByRoleId(roleId);
            this.roleBiz.deleteEntity(roleId);
            this.getHistoryPageNoByCookie(request);
        }
        return pageNo;
    }

    @RequestMapping(value={"/allDelete"})
    @ResponseBody
    public int allDelete(HttpServletRequest request) {
        int pageNo = 1;
        String[] ids = request.getParameterValues("ids");
        if (!StringUtil.isBlank((String[])ids)) {
            this.roleBiz.deleteAll(ids);
            this.getHistoryPageNoByCookie(request);
        }
        return pageNo;
    }
}

