/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.IAppBiz;
import com.mingsoft.basic.biz.IManagerBiz;
import com.mingsoft.basic.biz.IModelBiz;
import com.mingsoft.basic.biz.IRoleBiz;
import com.mingsoft.basic.biz.IRoleModelBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.constant.e.CookieConstEnum;
import com.mingsoft.basic.entity.AppEntity;
import com.mingsoft.basic.entity.ManagerEntity;
import com.mingsoft.basic.entity.ManagerSessionEntity;
import com.mingsoft.basic.entity.RoleEntity;
import com.mingsoft.basic.entity.RoleModelEntity;
import com.mingsoft.util.PageUtil;
import com.mingsoft.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/manager/manager"})
public class ManagerAction
extends BaseAction {
    @Autowired
    private IManagerBiz managerBiz;
    @Autowired
    private IRoleBiz roleBiz;
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IRoleModelBiz roleModelBiz;
    @Autowired
    private IAppBiz appBiz;
    private static final String PAGE_URL = "/manager/manager/queryList.do";

    @RequestMapping(value={"/queryList"})
    public String queryList(HttpServletRequest request, ModelMap model, HttpServletResponse response) {
        List<Object> listManager = new ArrayList();
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        if (managerSession.getManagerRoleID() == 2) {
            listManager = this.managerBiz.queryAllChildManager(managerSession.getManagerId());
            listManager.add((Object)managerSession);
        } else {
            listManager = this.managerBiz.queryAllChildManager(managerSession.getManagerParentID());
        }
        String pageNo = request.getParameter("pageNo");
        if (!StringUtil.isInteger((String)pageNo)) {
            pageNo = "1";
        }
        int recordCount = listManager.size();
        PageUtil page = new PageUtil(StringUtil.string2Int((String)pageNo), recordCount, String.valueOf(this.getUrl(request)) + PAGE_URL);
        this.setCookie(request, response, CookieConstEnum.PAGENO_COOKIE, pageNo);
        listManager = this.managerBiz.queryByPage(managerSession.getManagerId(), page, "m.MANAGER_ID", false);
        request.setAttribute("managerSession", (Object)managerSession);
        List<BaseEntity> listRole = this.roleBiz.queryRoleByManagerId(managerSession.getManagerId());
        if (listRole != null) {
            model.addAttribute("listRole", listRole);
        }
        model.addAttribute("listManager", listManager);
        model.addAttribute("page", (Object)page);
        return "/manager/manager/manager";
    }

    public void queryRoleList(Map model, HttpServletRequest request) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        List<BaseEntity> listRole = this.roleBiz.queryRoleByManagerId(managerSession.getManagerId());
        if (listRole != null) {
            model.put("listRole", listRole);
        }
    }

    public void queryModelList(HttpServletRequest request, Map model) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        List<BaseEntity> listModel = null;
        listModel = managerSession.getManagerRoleID() == 1 ? this.modelBiz.queryModelByManager() : this.modelBiz.queryModelByRoleId(managerSession.getManagerRoleID());
        if (!StringUtil.isBlank(listModel)) {
            model.put("listModel", listModel);
        }
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    public Map add(HttpServletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        this.queryRoleList(model, request);
        this.queryModelList(request, model);
        model.put("flag", true);
        model.put("listSelModel", "");
        return model;
    }

    @RequestMapping(value={"/{managerId}/edit"})
    @ResponseBody
    public Map edit(@PathVariable int managerId, HttpServletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        this.queryRoleList(model, request);
        this.queryModelList(request, model);
        ManagerEntity manager = (ManagerEntity)this.managerBiz.getEntity(managerId);
        List<BaseEntity> listSelModel = this.modelBiz.queryModelByRoleId(manager.getManagerRoleID());
        manager.setManagerPassword(null);
        model.put("manager", (Object)manager);
        if (!StringUtil.isBlank(listSelModel)) {
            model.put("listSelModel", listSelModel);
        }
        model.put("flag", false);
        return model;
    }

    public boolean checkForm(ManagerEntity manager, HttpServletResponse response) {
        if (!StringUtil.checkLength((String)manager.getManagerName(), (int)1, (int)12)) {
            this.outJson(response, ModelCode.ROLE, false, this.getResString("err.length", new String[]{this.getResString("managerName"), "1", "12"}));
            return false;
        }
        if (!StringUtil.checkLength((String)manager.getManagerNickName(), (int)2, (int)15)) {
            this.outJson(response, ModelCode.ROLE, false, this.getResString("err.length", new String[]{this.getResString("managerNickName"), "2", "15"}));
            return false;
        }
        if (!StringUtil.isBlank((String)manager.getManagerPassword()) && !StringUtil.checkLength((String)manager.getManagerPassword(), (int)1, (int)16)) {
            this.outJson(response, ModelCode.ROLE, false, this.getResString("err.length", new String[]{this.getResString("managerPassword"), "1", "16"}));
            return false;
        }
        return true;
    }

    public void saveOrUpdateRole(RoleEntity role, HttpServletRequest request, HttpServletResponse response, boolean flag) {
        String oldRoleName = request.getParameter("oldRoleName");
        if (!flag && this.roleBiz.countRoleName(role.getRoleName(), role.getRoleManagerId()) != 0 && !role.getRoleName().equals(oldRoleName)) {
            this.outJson(response, ModelCode.ROLE, false, this.getResString("roleName.exist"));
            return;
        }
        if (flag) {
            this.roleBiz.saveEntity(role);
        } else {
            this.roleBiz.updateEntity(role);
        }
        int roleId = this.roleBiz.queryRoleByRoleName(role.getRoleName(), role.getRoleManagerId()).getRoleId();
        ArrayList<RoleModelEntity> roleModelList = null;
        String[] modelId = request.getParameterValues("modelIds");
        if (!StringUtil.isBlank((String[])modelId)) {
            modelId = modelId[0].split(",");
        }
        if (StringUtil.isBlank((String)modelId[0])) {
            this.roleModelBiz.deleteEntity(roleId);
            return;
        }
        roleModelList = new ArrayList<RoleModelEntity>();
        int i = 0;
        while (i < modelId.length) {
            RoleModelEntity roleModel = new RoleModelEntity();
            roleModel.setModelId(Integer.parseInt(modelId[i]));
            roleModel.setRoleId(this.roleBiz.queryRoleByRoleName(role.getRoleName(), role.getRoleManagerId()).getRoleId());
            roleModelList.add(roleModel);
            ++i;
        }
        if (flag) {
            this.roleModelBiz.saveEntity(roleModelList);
        } else {
            this.roleModelBiz.deleteEntity(roleId);
            this.roleModelBiz.updateEntity(roleModelList);
        }
    }

    public void saveOrUpdateManager(boolean flag, ManagerEntity manager, HttpServletRequest request, HttpServletResponse response) {
        String oldManagerName = request.getParameter("oldManagerName");
        String oldPassword = manager.getManagerPassword();
        int count = this.managerBiz.countManagerName(manager.getManagerName());
        if (count > 0 && flag) {
            this.outJson(response, ModelCode.ROLE, false, this.getResString("err.exist", new String[]{this.getResString("managerName")}));
            return;
        }
        if (count > 0 && !manager.getManagerName().equals(oldManagerName)) {
            this.outJson(response, ModelCode.ROLE, false, this.getResString("err.exist", new String[]{this.getResString("managerName")}));
            return;
        }
        if (!this.checkForm(manager, response)) {
            return;
        }
        int websiteID = 0;
        int managerId = 0;
        String basicId = request.getParameter("basicId");
        if (!StringUtil.isBlank((String)basicId)) {
            RoleEntity role = new RoleEntity();
            if (flag) {
                manager.setManagerPassword(StringUtil.Md5((String)manager.getManagerPassword()));
                websiteID = Integer.parseInt(basicId);
                this.managerBiz.saveEntity((BaseEntity)manager);
                role.setRoleName(manager.getManagerName());
                managerId = this.managerBiz.queryManagerByManagerName(manager.getManagerName()).getManagerId();
                role.setRoleManagerId(managerId);
                this.saveOrUpdateRole(role, request, response, true);
                AppEntity website = (AppEntity)this.appBiz.getEntity(websiteID);
                website.setAppManagerId(managerId);
                this.appBiz.updateEntity(website);
            } else {
                if ((manager = this.managerBiz.queryManagerByManagerName(manager.getManagerName())) == null) {
                    return;
                }
                int roleId = manager.getManagerRoleID();
                role = (RoleEntity)this.roleBiz.getEntity(roleId);
                String[] modelId = request.getParameterValues("modelIds");
                if (!StringUtil.isBlank((String[])modelId)) {
                    modelId = modelId[0].split(",");
                }
                if (StringUtil.isBlank((String)modelId[0])) {
                    this.roleModelBiz.deleteEntity(roleId);
                    return;
                }
                ArrayList<RoleModelEntity> roleModelList = new ArrayList<RoleModelEntity>();
                int i = 0;
                while (i < modelId.length) {
                    RoleModelEntity roleModel = new RoleModelEntity();
                    roleModel.setModelId(Integer.parseInt(modelId[i]));
                    roleModel.setRoleId(this.roleBiz.queryRoleByRoleName(role.getRoleName(), role.getRoleManagerId()).getRoleId());
                    roleModelList.add(roleModel);
                    ++i;
                }
                this.roleModelBiz.deleteEntity(roleId);
                this.roleModelBiz.updateEntity(roleModelList);
            }
            manager.setManagerRoleID(this.roleBiz.queryRoleByRoleName(role.getRoleName(), role.getRoleManagerId()).getRoleId());
            if (!StringUtil.isBlank((String)manager.getManagerPassword())) {
                manager.setManagerPassword(StringUtil.Md5((String)oldPassword));
                this.managerBiz.updateEntity((BaseEntity)manager);
            }
        } else {
            if (!StringUtil.isBlank((String)manager.getManagerPassword())) {
                manager.setManagerPassword(StringUtil.Md5((String)manager.getManagerPassword()));
            }
            if (flag) {
                this.managerBiz.saveEntity((BaseEntity)manager);
            } else if (!StringUtil.isBlank((String)manager.getManagerPassword())) {
                this.managerBiz.updateEntity((BaseEntity)manager);
            }
        }
        if (flag) {
            this.outJson(response, ModelCode.ROLE, true, "1");
        } else {
            this.getHistoryPageNoByCookie(request);
            this.outJson(response, ModelCode.ROLE, true);
        }
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public void save(@ModelAttribute ManagerEntity manager, HttpServletRequest request, HttpServletResponse response) {
        this.saveOrUpdateManager(true, manager, request, response);
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    public void update(@ModelAttribute ManagerEntity manager, HttpServletRequest request, HttpServletResponse response) {
        this.saveOrUpdateManager(false, manager, request, response);
    }

    @RequestMapping(value={"/judgeManagerNameExist"})
    @ResponseBody
    public boolean judgeManagerNameExist(@RequestParam(value="managerName") String managerName) {
        return !StringUtil.isBlank((Object)this.managerBiz.countManagerName(managerName));
    }

    @RequestMapping(value={"/{managerId}/delete"})
    @ResponseBody
    public int delete(@PathVariable int managerId, HttpServletRequest request) {
        int pageNo = 1;
        if (managerId != 0) {
            this.managerBiz.deleteEntity(managerId);
            this.getHistoryPageNoByCookie(request);
        }
        return pageNo;
    }

    @RequestMapping(value={"/allDelete"})
    @ResponseBody
    public int allDelete(HttpServletRequest request) {
        int pageNo = 1;
        String[] checkboxData = request.getParameterValues("checkbox");
        if (!StringUtil.isBlank((String[])checkboxData)) {
            int i = 0;
            while (i < checkboxData.length) {
                this.managerBiz.deleteEntity(Integer.parseInt(checkboxData[i]));
                ++i;
            }
            this.getHistoryPageNoByCookie(request);
        }
        return pageNo;
    }
}

