/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.basic.action;

import com.alibaba.fastjson.JSONObject;
import com.mingsoft.base.entity.BaseEntity;
import com.mingsoft.basic.action.BaseAction;
import com.mingsoft.basic.biz.IManagerBiz;
import com.mingsoft.basic.biz.IManagerModelPageBiz;
import com.mingsoft.basic.biz.IModelBiz;
import com.mingsoft.basic.constant.ModelCode;
import com.mingsoft.basic.constant.e.SessionConstEnum;
import com.mingsoft.basic.entity.ManagerModelPageEntity;
import com.mingsoft.basic.entity.ManagerSessionEntity;
import com.mingsoft.basic.entity.ModelEntity;
import com.mingsoft.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/manager"})
public class MainAction
extends BaseAction {
    @Autowired
    private IModelBiz modelBiz;
    @Autowired
    private IManagerBiz managerBiz;
    @Autowired
    private IManagerModelPageBiz managerModelPageBiz;

    @RequestMapping(value={"/index"})
    public String index(HttpServletRequest request) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        List<Object> modelList = new ArrayList();
        modelList = this.modelBiz.queryModelByRoleId(managerSession.getManagerRoleID());
        request.setAttribute("managerSession", (Object)managerSession);
        request.setAttribute("modelList", (Object)JSONObject.toJSONString(modelList));
        int managerId = managerSession.getManagerId();
        ManagerModelPageEntity managerModelPage = this.managerModelPageBiz.getByManagerIdAndModelId(managerId, 0);
        if (managerModelPage != null) {
            request.setAttribute("managerModelPage", (Object)managerModelPage);
        }
        return "/manager/index";
    }

    @RequestMapping(value={"/{modelId}/queryListByModelId"}, method={RequestMethod.POST})
    @ResponseBody
    public Map queryListByModelId(@PathVariable int modelId, HttpServletRequest request) {
        HashMap<String, List<BaseEntity>> modelMap = new HashMap<String, List<BaseEntity>>();
        List<BaseEntity> modelList = null;
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        if (this.isSystemManager(request) && modelId == 1) {
            modelList = this.modelBiz.queryModelByManagerId(1, modelId);
        } else if (this.isSystemManager(request)) {
            modelList = this.modelBiz.queryChildList(modelId);
        } else {
            modelList = this.modelBiz.queryModelByRoleId(managerSession.getManagerRoleID());
            int i = 0;
            while (i < modelList.size()) {
                ModelEntity model = (ModelEntity)modelList.get(i);
                if (model.getModelModelId() != modelId) {
                    modelList.remove(i);
                    --i;
                }
                ++i;
            }
        }
        modelMap.put("modelList", modelList);
        return modelMap;
    }

    @RequestMapping(value={"/editPassword"})
    @ResponseBody
    public void editPassword(HttpServletResponse response, HttpServletRequest request) {
        ManagerSessionEntity manager = this.getManagerBySession(request);
        this.outJson(response, ModelCode.ROLE, false, JSONObject.toJSONString((Object)manager.getManagerName()));
    }

    @RequestMapping(value={"/updatePassword"})
    @ResponseBody
    public void updatePassword(HttpServletResponse response, HttpServletRequest request) {
        String oldManagerPassword = StringUtil.Md5((String)request.getParameter("oldManagerPassword"));
        String newManagerPassword = request.getParameter("newManagerPassword");
        ManagerSessionEntity manager = this.getManagerBySession(request);
        if (StringUtil.isBlank((String)newManagerPassword) || StringUtil.isBlank((String)oldManagerPassword)) {
            this.outJson(response, ModelCode.ROLE, false, this.getResString("err.empty", new String[]{this.getResString("managerPassword")}));
            return;
        }
        if (!oldManagerPassword.equals(manager.getManagerPassword())) {
            this.outJson(response, ModelCode.ROLE, false, this.getResString("err.password", new String[]{this.getResString("managerPassword")}));
            return;
        }
        if (!StringUtil.checkLength((String)newManagerPassword, (int)1, (int)16)) {
            this.outJson(response, ModelCode.ROLE, false, this.getResString("err.length", new String[]{this.getResString("managerPassword"), "1", "16"}));
            return;
        }
        manager.setManagerPassword(StringUtil.Md5((String)newManagerPassword));
        this.managerBiz.updateUserPasswordByUserName(manager);
        this.outJson(response, ModelCode.ROLE, true, null);
    }

    @RequestMapping(value={"/loginOut"})
    @ResponseBody
    public boolean loginOut(HttpServletRequest request) {
        this.removeSession(request, SessionConstEnum.MANAGER_ESSION);
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        return true;
    }

    @RequestMapping(value={"/ui"})
    public String ui(HttpServletRequest request) {
        return "/manager/ui";
    }

    @RequestMapping(value={"/ui/list"})
    public String list(HttpServletRequest request) {
        return "/manager/ui/list";
    }

    @RequestMapping(value={"/ui/form"})
    public String form(HttpServletRequest request) {
        return "/manager/ui/from";
    }
}

