/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.query.dataorder;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.luckperms.api.model.data.DataType;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum DataTypeFilter implements Predicate<DataType>
{
    ALL{

        @Override
        public boolean test(DataType dataType) {
            return true;
        }
    }
    ,
    NONE{

        @Override
        public boolean test(DataType dataType) {
            return false;
        }
    }
    ,
    NORMAL_ONLY{

        @Override
        public boolean test(DataType dataType) {
            return dataType == DataType.NORMAL;
        }
    }
    ,
    TRANSIENT_ONLY{

        @Override
        public boolean test(DataType dataType) {
            return dataType == DataType.TRANSIENT;
        }
    };

    private static final List<DataType> ALL_LIST;
    private static final List<DataType> NORMAL_ONLY_LIST;
    private static final List<DataType> TRANSIENT_ONLY_LIST;

    public static @NonNull List<DataType> values(@NonNull Predicate<? super DataType> predicate) {
        boolean normal = predicate.test(DataType.NORMAL);
        boolean trans = predicate.test(DataType.TRANSIENT);
        if (normal && trans) {
            return ALL_LIST;
        }
        if (normal) {
            return NORMAL_ONLY_LIST;
        }
        if (trans) {
            return TRANSIENT_ONLY_LIST;
        }
        return Collections.emptyList();
    }

    static {
        ALL_LIST = Collections.unmodifiableList(Arrays.asList(DataType.NORMAL, DataType.TRANSIENT));
        NORMAL_ONLY_LIST = Collections.unmodifiableList(Collections.singletonList(DataType.NORMAL));
        TRANSIENT_ONLY_LIST = Collections.unmodifiableList(Collections.singletonList(DataType.TRANSIENT));
    }
}

