/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.parser;

import java.text.Format;
import java.text.ParseException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.coderazzi.filters.IParser;
import net.coderazzi.filters.artifacts.RowFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
implements IParser {
    FormatWrapper format;
    Comparator comparator;
    boolean ignoreCase;
    Comparator<String> stringComparator;
    int modelIndex;
    private static Map<String, IOperand> operands;
    private static IOperand nullOperand;
    private static Pattern expressionMatcher;

    public Parser(Format format, Comparator classComparator, Comparator<String> stringComparator, boolean ignoreCase, int modelIndex) {
        this.format = new FormatWrapper(format);
        this.comparator = classComparator;
        this.stringComparator = stringComparator;
        this.ignoreCase = ignoreCase;
        this.modelIndex = modelIndex;
    }

    @Override
    public RowFilter parseText(String expression) throws ParseException {
        Matcher matcher = expressionMatcher.matcher(expression);
        if (matcher.matches()) {
            IOperand op = operands.get(matcher.group(1));
            if (op == null) {
                op = nullOperand;
            }
            return op.create(this, matcher.group(2).trim());
        }
        return null;
    }

    @Override
    public String escape(String expression) {
        boolean needs = true;
        Matcher matcher = expressionMatcher.matcher(expression = expression.trim());
        if (matcher.matches()) {
            String operand = matcher.group(1);
            if (operand == null) {
                try {
                    if (this.format.format != null && this.format.parseObject(expression) != null) {
                        needs = false;
                    }
                }
                catch (ParseException pex) {
                    // empty catch block
                }
                needs = needs && !expression.equals(Parser.convertWilcardExpressionToRegularExpression(expression));
            } else {
                needs = true;
            }
        }
        return needs ? "= " + expression : expression;
    }

    static String convertWilcardExpressionToRegularExpression(String s) {
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        block6: for (char c : s.toCharArray()) {
            switch (c) {
                case '\\': {
                    if (escaped) {
                        sb.append("\\");
                    }
                    escaped = !escaped;
                    continue block6;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    sb.append('\\').append(c);
                    escaped = false;
                    continue block6;
                }
                case '*': {
                    if (escaped) {
                        sb.append("\\*");
                        escaped = false;
                        continue block6;
                    }
                    sb.append(".*");
                    continue block6;
                }
                case '?': {
                    if (escaped) {
                        sb.append("\\?");
                        escaped = false;
                        continue block6;
                    }
                    sb.append(".");
                    continue block6;
                }
                default: {
                    sb.append(c);
                    escaped = false;
                }
            }
        }
        return sb.toString();
    }

    static {
        expressionMatcher = Pattern.compile("^(>=|<=|<>|!~|~~|>|<|=|~|!)?\\s*(.*)$");
        EqualOperand equalOperand = new EqualOperand(true);
        nullOperand = new NullOperand(equalOperand);
        operands = new HashMap<String, IOperand>();
        operands.put("~~", new REOperand(true));
        operands.put("!~", new SimpleREOperand(false));
        operands.put("!", new EqualOperand(false));
        operands.put("=", equalOperand);
        operands.put(">=", new ComparisonOperand(){

            boolean matches(int comparison) {
                return comparison >= 0;
            }
        });
        operands.put(">", new ComparisonOperand(){

            boolean matches(int comparison) {
                return comparison > 0;
            }
        });
        operands.put("<=", new ComparisonOperand(){

            boolean matches(int comparison) {
                return comparison <= 0;
            }
        });
        operands.put("<", new ComparisonOperand(){

            boolean matches(int comparison) {
                return comparison < 0;
            }
        });
        operands.put("<>", new ComparisonOperand(){

            boolean matches(int comparison) {
                return comparison != 0;
            }
        });
        operands.put("~", new SimpleREOperand(true));
    }

    static class FormatWrapper {
        Format format;

        FormatWrapper(Format format) {
            this.format = format;
        }

        public String format(Object o) {
            return this.format == null ? (o == null ? "" : o.toString()) : this.format.format(o);
        }

        public Object parseObject(String content) throws ParseException {
            return this.format == null ? null : this.format.parseObject(content);
        }
    }

    static class NullOperand
    extends SimpleREOperand {
        IOperand defaultOperand;

        public NullOperand(IOperand defaultOperand) {
            super(true);
            this.defaultOperand = defaultOperand;
        }

        public RowFilter create(Parser self, String right) throws ParseException {
            boolean problem = false;
            if (self.comparator != null) {
                try {
                    return this.defaultOperand.create(self, right);
                }
                catch (ParseException pex) {
                    problem = true;
                }
            }
            RowFilter ret = super.create(self, right);
            if (problem && !this.wildcardExpression()) {
                throw new ParseException(right, 0);
            }
            return ret;
        }
    }

    static class SimpleREOperand
    extends REOperand {
        private boolean wildcardExpression;

        public SimpleREOperand(boolean equals) {
            super(equals);
        }

        public boolean wildcardExpression() {
            return this.wildcardExpression;
        }

        protected Pattern getPattern(String right, boolean ignoreCase) throws ParseException {
            String converted = Parser.convertWilcardExpressionToRegularExpression(right);
            this.wildcardExpression = !converted.equals(right);
            return super.getPattern(converted, ignoreCase);
        }
    }

    static class REOperand
    implements IOperand {
        boolean equals;

        public REOperand(boolean equals) {
            this.equals = equals;
        }

        public RowFilter create(Parser self, String right) throws ParseException {
            return this.createWithPattern(self, this.getPattern(right, self.ignoreCase));
        }

        protected RowFilter createWithPattern(Parser self, final Pattern pattern) {
            final int modelIndex = self.modelIndex;
            final FormatWrapper format = self.format;
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object o = entry.getValue(modelIndex);
                    String left = format.format(o);
                    return REOperand.this.equals == pattern.matcher(left).matches();
                }
            };
        }

        protected Pattern getPattern(String right, boolean ignoreCase) throws ParseException {
            try {
                return Pattern.compile(right, ignoreCase ? 2 : 0);
            }
            catch (PatternSyntaxException pse) {
                throw new ParseException("", pse.getIndex());
            }
        }
    }

    static class EqualOperand
    implements IOperand {
        boolean expected;

        public EqualOperand(boolean expected) {
            this.expected = expected;
        }

        public RowFilter create(Parser self, String right) throws ParseException {
            if (self.comparator == null) {
                return this.createStringOperator(right, self.modelIndex, self.format, self.stringComparator);
            }
            if (right.length() == 0) {
                return this.createNullOperator(self.modelIndex);
            }
            Object o = self.format.parseObject(right);
            if (o == null) {
                throw new ParseException("", 0);
            }
            return this.createOperator(o, self.modelIndex, self.comparator);
        }

        private RowFilter createOperator(final Object right, final int modelIndex, final Comparator comparator) {
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object left = entry.getValue(modelIndex);
                    boolean value = left != null && 0 == comparator.compare(left, right);
                    return value == EqualOperand.this.expected;
                }
            };
        }

        private RowFilter createNullOperator(final int modelIndex) {
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object left = entry.getValue(modelIndex);
                    return EqualOperand.this.expected == (left == null);
                }
            };
        }

        private RowFilter createStringOperator(final String right, final int modelIndex, final FormatWrapper format, final Comparator stringComparator) {
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object left = entry.getValue(modelIndex);
                    String value = format.format(left);
                    EqualOperand.this.expected = stringComparator.compare(value, right) == 0;
                    return EqualOperand.this.expected;
                }
            };
        }
    }

    static abstract class ComparisonOperand
    implements IOperand {
        ComparisonOperand() {
        }

        abstract boolean matches(int var1);

        public RowFilter create(Parser self, String right) throws ParseException {
            if (right == null) {
                throw new ParseException("", 0);
            }
            if (self.comparator == null) {
                return this.createStringOperator(right, self.modelIndex, self.format, self.stringComparator);
            }
            Object o = self.format.parseObject(right);
            if (o == null) {
                throw new ParseException("", 0);
            }
            return this.createOperator(o, self.modelIndex, self.comparator);
        }

        private RowFilter createOperator(final Object right, final int modelIndex, final Comparator comparator) {
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object left = entry.getValue(modelIndex);
                    return left != null && ComparisonOperand.this.matches(comparator.compare(left, right));
                }
            };
        }

        private RowFilter createStringOperator(final String right, final int modelIndex, final FormatWrapper format, final Comparator stringComparator) {
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object left = entry.getValue(modelIndex);
                    if (left == null) {
                        return false;
                    }
                    String s = format.format(left);
                    return s.length() > 0 && ComparisonOperand.this.matches(stringComparator.compare(s, right));
                }
            };
        }
    }

    static interface IOperand {
        public RowFilter create(Parser var1, String var2) throws ParseException;
    }
}

