/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.parser;

import java.text.Format;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateComparator
implements Comparator<Date> {
    public static DateComparator getDateComparator(Format dateFormat) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(new Date().getTime());
        if (DateComparator.change(calendar, dateFormat, 14)) {
            return new DateComparator(){

                public long diff(Date o1, Date o2) {
                    return o1.compareTo(o2);
                }
            };
        }
        int divisor = 0;
        if (DateComparator.change(calendar, dateFormat, 13)) {
            divisor = 1000;
        } else if (DateComparator.change(calendar, dateFormat, 12)) {
            divisor = 60000;
        } else if (DateComparator.change(calendar, dateFormat, 10)) {
            divisor = 3600000;
        } else {
            if (DateComparator.change(calendar, dateFormat, 6)) {
                return new DayMonthYearComparator(calendar);
            }
            if (DateComparator.change(calendar, dateFormat, 2)) {
                return new MonthYearComparator(calendar);
            }
            if (DateComparator.change(calendar, dateFormat, 1)) {
                return new YearComparator(calendar);
            }
            return new DateComparator(){

                public long diff(Date o1, Date o2) {
                    return 0L;
                }
            };
        }
        return new TimeComparator(divisor);
    }

    private static boolean change(Calendar c, Format f, int field) {
        c.set(field, 10);
        String sf = f.format(c.getTime());
        c.set(field, 11);
        return !sf.equals(f.format(c.getTime()));
    }

    @Override
    public int compare(Date o1, Date o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        long diff = this.diff(o1, o2);
        return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
    }

    public abstract long diff(Date var1, Date var2);

    static class DayMonthYearComparator
    extends YearComparator {
        public DayMonthYearComparator(Calendar calendar) {
            super(calendar);
        }

        long time() {
            return this.calendar.get(1) * 400 + this.calendar.get(6);
        }
    }

    static class MonthYearComparator
    extends YearComparator {
        public MonthYearComparator(Calendar calendar) {
            super(calendar);
        }

        long time() {
            return this.calendar.get(1) * 12 + this.calendar.get(2);
        }
    }

    static class YearComparator
    extends DateComparator {
        Calendar calendar;

        public YearComparator(Calendar calendar) {
            this.calendar = calendar;
        }

        public long diff(Date o1, Date o2) {
            this.calendar.setTime(o1);
            long base = this.time();
            this.calendar.setTime(o2);
            return base - this.time();
        }

        long time() {
            return this.calendar.get(1);
        }
    }

    static class TimeComparator
    extends DateComparator {
        int divisor;

        public TimeComparator(int divisor) {
            this.divisor = divisor;
        }

        public long diff(Date o1, Date o2) {
            return o1.getTime() / (long)this.divisor - o2.getTime() / (long)this.divisor;
        }
    }
}

