/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import net.coderazzi.filters.AndFilter;
import net.coderazzi.filters.IFilter;
import net.coderazzi.filters.IFilterObserver;
import net.coderazzi.filters.artifacts.ITableModelFilter;
import net.coderazzi.filters.artifacts.TableModelFilter;
import net.coderazzi.filters.gui.AutoChoices;
import net.coderazzi.filters.gui.ChoicesHandler;
import net.coderazzi.filters.gui.FilterSettings;
import net.coderazzi.filters.gui.IParserModel;
import net.coderazzi.filters.gui.NonAdaptiveChoicesHandler;
import net.coderazzi.filters.gui.editor.FilterEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FiltersHandler
extends AndFilter
implements PropertyChangeListener {
    int sendNotifications = 0;
    private boolean pendingNotifications;
    private AutoChoices autoChoices = FilterSettings.autoChoices;
    private Map<Integer, FilterEditor> editors = new HashMap<Integer, FilterEditor>();
    private JTable table;
    private ChoicesHandler choicesHandler = new NonAdaptiveChoicesHandler(this);
    private IParserModel parserModel;

    FiltersHandler() {
        this.addFilterObserver(new IFilterObserver(){

            public void filterUpdated(IFilter obs) {
                FiltersHandler.this.notifyUpdatedFilter();
            }
        });
    }

    public void setTable(JTable table) {
        TableModel tm;
        this.choicesHandler.setInterrupted(true);
        if (this.table != null && (tm = this.table.getModel()) instanceof ITableModelFilter) {
            this.table.setModel(((ITableModelFilter)((Object)tm)).getModel());
        }
        this.table = table;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setParserModel(IParserModel parserModel) {
        if (parserModel != null && parserModel != this.parserModel) {
            if (this.parserModel != null) {
                this.parserModel.removePropertyChangeListener(this);
            }
            this.parserModel = parserModel;
            this.parserModel.addPropertyChangeListener(this);
            this.enableNotifications(false);
            for (FilterEditor editor : this.editors.values()) {
                editor.resetFilter();
            }
            this.enableNotifications(true);
        }
        this.parserModel = parserModel;
    }

    public IParserModel getParserModel() {
        return this.parserModel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Class target;
        boolean formatChange = false;
        if (evt.getPropertyName() == "ignoreCase") {
            target = null;
        } else {
            if (evt.getPropertyName() == "format") {
                formatChange = true;
            } else if (evt.getPropertyName() != "comparator") {
                return;
            }
            Object cl = evt.getNewValue();
            if (cl instanceof Class) {
                target = (Class)cl;
            } else {
                return;
            }
        }
        this.enableNotifications(false);
        for (FilterEditor editor : this.editors.values()) {
            if (target == null) {
                editor.setIgnoreCase(this.parserModel.isIgnoreCase());
                continue;
            }
            if (editor.getModelClass() != target) continue;
            if (formatChange) {
                editor.setFormat(this.parserModel.getFormat(target));
                continue;
            }
            editor.setComparator(this.parserModel.getComparator(target));
        }
        this.enableNotifications(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enableNotifications(false);
        super.setEnabled(enabled);
        this.enableNotifications(true);
    }

    public void setAutoChoices(AutoChoices mode) {
        if (mode != this.autoChoices) {
            this.enableNotifications(false);
            this.autoChoices = mode;
            for (FilterEditor editor : this.editors.values()) {
                editor.setAutoChoices(mode);
            }
            this.enableNotifications(true);
        }
    }

    public AutoChoices getAutoChoices() {
        return this.autoChoices;
    }

    @Override
    public void addFilter(IFilter ... filtersToAdd) {
        this.choicesHandler.filterOperation(true);
        super.addFilter(filtersToAdd);
        this.choicesHandler.filterOperation(false);
    }

    @Override
    public void removeFilter(IFilter ... filtersToRemove) {
        this.choicesHandler.filterOperation(true);
        super.removeFilter(filtersToRemove);
        this.choicesHandler.filterOperation(false);
    }

    public void addFilterEditor(FilterEditor editor) {
        super.addFilter(editor.getFilter());
        this.editors.put(editor.getModelIndex(), editor);
        editor.setAutoChoices(this.autoChoices);
    }

    public void removeFilterEditor(FilterEditor editor) {
        super.removeFilter(editor.getFilter());
        this.editors.remove(editor.getModelIndex());
    }

    public void updateEditorChoices(FilterEditor editor) {
        if (this.editors.containsValue(editor) && this.isEnabled()) {
            this.choicesHandler.editorUpdated(editor);
        }
    }

    @Override
    public void filterUpdated(IFilter filter) {
        boolean wasEnabled = this.isEnabled();
        boolean filterWasDisabled = this.isDisabled(filter);
        this.choicesHandler.filterUpdated(filter);
        super.filterUpdated(filter);
        if (filterWasDisabled && filter.isEnabled()) {
            this.choicesHandler.filterEnabled(filter);
        } else if (wasEnabled && !this.isEnabled()) {
            this.choicesHandler.allFiltersDisabled();
        }
    }

    public void updateTableFilter() {
        TableModel model;
        this.pendingNotifications = false;
        if (this.table != null && (model = this.table.getModel()) != null) {
            this.getRowFilter(model).setRowFilter(this.isEnabled() ? this : null);
        }
    }

    public Collection<FilterEditor> getEditors() {
        return this.editors.values();
    }

    public FilterEditor getEditor(int column) {
        return this.editors.get(column);
    }

    public void enableNotifications(boolean enable) {
        this.sendNotifications += enable ? 1 : -1;
        if (enable) {
            if (this.sendNotifications == 0 && (this.choicesHandler.setInterrupted(false) || this.pendingNotifications)) {
                this.updateTableFilter();
            }
        } else if (this.choicesHandler.setInterrupted(true)) {
            this.updateTableFilter();
        }
    }

    void notifyUpdatedFilter() {
        if (this.sendNotifications < 0) {
            this.pendingNotifications = true;
        } else {
            this.updateTableFilter();
        }
    }

    private ITableModelFilter getRowFilter(TableModel tableModel) {
        if (tableModel instanceof ITableModelFilter) {
            return (TableModelFilter)tableModel;
        }
        TableModelFilter modelFilter = new TableModelFilter(tableModel);
        this.table.setModel(modelFilter);
        return modelFilter;
    }
}

