/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMFiles;
import kr.jm.utils.helper.JMResources;
import kr.jm.utils.helper.JMRestfulResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMJson {
    private static final Logger log = LoggerFactory.getLogger(JMJson.class);
    public static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = JMJson.getMapOrListTypeReference();
    public static final TypeReference<List<Object>> LIST_TYPE_REFERENCE = JMJson.getMapOrListTypeReference();
    public static final TypeReference<List<Map<String, Object>>> LIST_MAP_TYPE_REFERENCE = JMJson.getMapOrListTypeReference();
    private static ObjectMapper jsonMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);

    public static <T> TypeReference<T> getMapOrListTypeReference() {
        return new TypeReference<T>(){};
    }

    public static <D> String toJsonString(D dataObject) {
        try {
            return jsonMapper.writeValueAsString(dataObject);
        }
        catch (Exception e) {
            return (String)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"toJsonString", (Object[])new Object[]{dataObject});
        }
    }

    public static String toJsonString(File jsonFile) {
        return JMFiles.readString((File)jsonFile);
    }

    public static File toJsonFile(String jsonString, File returnJsonFile) {
        try {
            jsonMapper.writeValue(returnJsonFile, (Object)jsonString);
            return returnJsonFile;
        }
        catch (Exception e) {
            return (File)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"toJsonFile", (Object[])new Object[]{jsonString});
        }
    }

    public static <D> File toJsonFile(D dataObject, File returnJsonFile) {
        try {
            jsonMapper.writeValue(returnJsonFile, dataObject);
            return returnJsonFile;
        }
        catch (Exception e) {
            return (File)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"toJsonFile", (Object[])new Object[]{dataObject});
        }
    }

    public static <T> T withBytes(byte[] bytes, TypeReference<T> typeReference) {
        try {
            return (T)jsonMapper.readValue(bytes, typeReference);
        }
        catch (Exception e) {
            return (T)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"withBytes", (Object[])new Object[]{new String(bytes)});
        }
    }

    public static <T> T withBytes(byte[] bytes, Class<T> c) {
        try {
            return (T)jsonMapper.readValue(bytes, c);
        }
        catch (Exception e) {
            return (T)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"withBytes", (Object[])new Object[]{new String(bytes)});
        }
    }

    public static <T> T withJsonString(String jsonString, TypeReference<T> typeReference) {
        return JMJson.withBytes(jsonString.getBytes(), typeReference);
    }

    public static Map<String, Object> toMap(String jsonObjectString) {
        return JMJson.withJsonString(jsonObjectString, MAP_TYPE_REFERENCE);
    }

    public static List<Object> toList(String jsonListString) {
        return JMJson.withJsonString(jsonListString, LIST_TYPE_REFERENCE);
    }

    public static List<Map<String, Object>> toMapList(String jsonMapListString) {
        return JMJson.withJsonString(jsonMapListString, LIST_MAP_TYPE_REFERENCE);
    }

    public static <T> T withJsonString(String jsonString, Class<T> c) {
        return JMJson.withBytes(jsonString.getBytes(), c);
    }

    public static <T> T withJsonFile(File jsonFile, TypeReference<T> typeReference) {
        try {
            return (T)jsonMapper.readValue(jsonFile, typeReference);
        }
        catch (Exception e) {
            return (T)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"withJsonFile", (Object[])new Object[]{jsonFile});
        }
    }

    public static <T> T withJsonFile(File jsonFile, Class<T> c) {
        try {
            return (T)jsonMapper.readValue(jsonFile, c);
        }
        catch (Exception e) {
            return (T)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"withJsonFile", (Object[])new Object[]{jsonFile});
        }
    }

    public static <T> T withJsonInputStream(InputStream inputStream, TypeReference<T> typeReference) {
        try {
            return (T)jsonMapper.readValue(inputStream, typeReference);
        }
        catch (Exception e) {
            return (T)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"withJsonInputStream", (Object[])new Object[]{inputStream});
        }
    }

    public static <T> T withJsonInputStream(InputStream inputStream, Class<T> c) {
        try {
            return (T)jsonMapper.readValue(inputStream, c);
        }
        catch (Exception e) {
            return (T)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"withJsonInputStream", (Object[])new Object[]{inputStream});
        }
    }

    public static <T> T withJsonResource(String resourceClasspath, TypeReference<T> typeReference) {
        return JMJson.withJsonInputStream(JMResources.getResourceInputStream((String)resourceClasspath), typeReference);
    }

    public static <T> T withJsonResource(String resourceClasspath, Class<T> c) {
        return JMJson.withJsonInputStream(JMResources.getResourceInputStream((String)resourceClasspath), c);
    }

    public static <T> T withRestOrClasspathOrFilePath(String resourceRestUrlOrClasspathOrFilePath, TypeReference<T> typeReference) {
        return JMJson.withJsonString(JMRestfulResource.getStringWithRestOrClasspathOrFilePath(resourceRestUrlOrClasspathOrFilePath), typeReference);
    }

    public static <T> T withRestOrFilePathOrClasspath(String resourceRestOrFilePathOrClasspath, TypeReference<T> typeReference) {
        return JMJson.withJsonString(JMRestfulResource.getStringWithRestOrFilePathOrClasspath(resourceRestOrFilePathOrClasspath), typeReference);
    }

    public static <T> T withClasspathOrFilePath(String resourceClasspathOrFilePath, TypeReference<T> typeReference) {
        return JMJson.withJsonString(JMResources.getStringWithClasspathOrFilePath((String)resourceClasspathOrFilePath), typeReference);
    }

    public static <T> T withFilePathOrClasspath(String resourceFilePathOrClasspath, TypeReference<T> typeReference) {
        return JMJson.withJsonString(JMResources.getStringWithFilePathOrClasspath((String)resourceFilePathOrClasspath), typeReference);
    }

    public static <T> Map<String, Object> transformToMap(T object) {
        return JMJson.transform(object, MAP_TYPE_REFERENCE);
    }

    public static <T1, T2> T2 transform(T1 object, TypeReference<T2> typeReference) {
        try {
            return (T2)jsonMapper.convertValue(object, typeReference);
        }
        catch (Exception e) {
            return (T2)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"transform", (Object[])new Object[]{object});
        }
    }

    public static <T1, T2> T2 transform(T1 object, Class<T2> typeClass) {
        try {
            return (T2)jsonMapper.convertValue(object, typeClass);
        }
        catch (Exception e) {
            return (T2)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"transform", (Object[])new Object[]{object});
        }
    }

    public static String toPrettyString(String jsonString) {
        return JMJson.toPrettyJsonString(JMJson.withJsonString(jsonString, Object.class));
    }

    public static String toPrettyJsonString(Object object) {
        try {
            return jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            return (String)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"toPrettyJsonString", (Object[])new Object[]{object});
        }
    }
}

