/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.processor;

import java.util.concurrent.Flow;
import java.util.function.Function;
import kr.jm.utils.enums.OS;
import kr.jm.utils.flow.processor.JMConcurrentProcessor;
import kr.jm.utils.flow.processor.JMProcessor;

public class JMProcessorBuilder {
    public static <I, O> JMProcessor<I, O> build(Function<I, O> transformerFunction) {
        return new JMProcessor<I, O>(transformerFunction);
    }

    public static <T, M, R> Flow.Processor<T, R> combine(final Flow.Processor<T, M> processor1, final Flow.Processor<M, R> processor2) {
        processor1.subscribe(processor2);
        return new Flow.Processor<T, R>(){

            @Override
            public void subscribe(Flow.Subscriber<? super R> subscriber) {
                processor2.subscribe(subscriber);
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                processor1.onSubscribe(subscription);
            }

            @Override
            public void onNext(T item) {
                processor1.onNext(item);
            }

            @Override
            public void onError(Throwable throwable) {
                processor1.onError(throwable);
            }

            @Override
            public void onComplete() {
                processor1.onComplete();
            }
        };
    }

    public static <I, O> JMConcurrentProcessor<I, O> buildWithThreadPool(Function<I, O> transformerFunction) {
        return JMProcessorBuilder.buildWithThreadPool(OS.getAvailableProcessors(), transformerFunction);
    }

    public static <I, O> JMConcurrentProcessor<I, O> buildWithThreadPool(int workers, Function<I, O> transformerFunction) {
        return new JMConcurrentProcessor<I, O>(workers, transformerFunction);
    }
}

