/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.processor;

import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kr.jm.utils.flow.processor.JMConcurrentTransformProcessor;
import kr.jm.utils.flow.processor.JMTransformProcessor;
import kr.jm.utils.flow.processor.JMTransformProcessorInterface;
import kr.jm.utils.flow.publisher.JMSubmissionPublisher;

public class JMTransformProcessorBuilder {
    public static <O, I extends Collection<O>> JMTransformProcessorInterface<I, O> buildCollectionEach() {
        return JMTransformProcessorBuilder.buildBi((collection, singleSubmissionPublisher) -> collection.forEach(singleSubmissionPublisher::submit));
    }

    public static <O, I extends Collection<O>, R> JMTransformProcessorInterface<I, R> buildCollectionEach(Function<O, R> eachTransformerFunction) {
        return JMTransformProcessorBuilder.buildBi((collection, singleSubmissionPublisher) -> collection.stream().map(eachTransformerFunction::apply).forEach(singleSubmissionPublisher::submit));
    }

    public static <O, I extends Collection<O>> JMConcurrentTransformProcessor<I, O> buildCollectionEachWithThreadPool() {
        return JMTransformProcessorBuilder.buildCollectionEachWithThreadPool(Flow.defaultBufferSize());
    }

    public static <O, I extends Collection<O>> JMConcurrentTransformProcessor<I, O> buildCollectionEachWithThreadPool(int maxBufferCapacity) {
        return JMTransformProcessorBuilder.buildCollectionEachWithThreadPool(null, maxBufferCapacity);
    }

    public static <O, I extends Collection<O>> JMConcurrentTransformProcessor<I, O> buildCollectionEachWithThreadPool(Executor executor, int maxBufferCapacity) {
        return JMTransformProcessorBuilder.buildWithThreadPool(executor, maxBufferCapacity, (I collection, JMSubmissionPublisher<? super O> singleSubmissionPublisher) -> collection.forEach(singleSubmissionPublisher::submit));
    }

    public static <O, I extends Collection<O>, R> JMConcurrentTransformProcessor<I, R> buildCollectionEachWithThreadPool(Function<O, R> eachTransformerFunction) {
        return JMTransformProcessorBuilder.buildCollectionEachWithThreadPool(Flow.defaultBufferSize(), eachTransformerFunction);
    }

    public static <O, I extends Collection<O>, R> JMConcurrentTransformProcessor<I, R> buildCollectionEachWithThreadPool(int maxBufferCapacity, Function<O, R> eachTransformerFunction) {
        return JMTransformProcessorBuilder.buildCollectionEachWithThreadPool(null, maxBufferCapacity, eachTransformerFunction);
    }

    public static <O, I extends Collection<O>, R> JMConcurrentTransformProcessor<I, R> buildCollectionEachWithThreadPool(Executor executor, int maxBufferCapacity, Function<O, R> eachTransformerFunction) {
        return JMTransformProcessorBuilder.buildWithThreadPool(executor, maxBufferCapacity, (I collection, JMSubmissionPublisher<? super O> singleSubmissionPublisher) -> collection.stream().map(eachTransformerFunction::apply).forEach(singleSubmissionPublisher::submit));
    }

    public static <I, O> JMTransformProcessorInterface<I, O> buildBi(BiConsumer<I, JMSubmissionPublisher<? super O>> singlePublisherBiConsumer) {
        return new JMTransformProcessor<I, O>(singlePublisherBiConsumer);
    }

    public static <I, O> JMTransformProcessor<I, O> build(Function<I, O> transformerFunction) {
        return new JMTransformProcessor<I, O>(transformerFunction);
    }

    public static <I, O> JMConcurrentTransformProcessor<I, O> buildWithThreadPool(BiConsumer<I, JMSubmissionPublisher<? super O>> singlePublisherBiConsumer) {
        return JMTransformProcessorBuilder.buildWithThreadPool(Flow.defaultBufferSize(), singlePublisherBiConsumer);
    }

    public static <I, O> JMConcurrentTransformProcessor<I, O> buildWithThreadPool(int maxBufferCapacity, BiConsumer<I, JMSubmissionPublisher<? super O>> singlePublisherBiConsumer) {
        return JMTransformProcessorBuilder.buildWithThreadPool(null, maxBufferCapacity, singlePublisherBiConsumer);
    }

    public static <I, O> JMConcurrentTransformProcessor<I, O> buildWithThreadPool(Executor executor, int maxBufferCapacity, BiConsumer<I, JMSubmissionPublisher<? super O>> singlePublisherBiConsumer) {
        return new JMConcurrentTransformProcessor<I, O>(executor, maxBufferCapacity, singlePublisherBiConsumer);
    }

    public static <I, O> JMConcurrentTransformProcessor<I, O> buildWithThreadPool(Function<I, O> transformerFunction) {
        return JMTransformProcessorBuilder.buildWithThreadPool(Flow.defaultBufferSize(), transformerFunction);
    }

    public static <I, O> JMConcurrentTransformProcessor<I, O> buildWithThreadPool(int maxBufferCapacity, Function<I, O> transformerFunction) {
        return JMTransformProcessorBuilder.buildWithThreadPool(null, maxBufferCapacity, transformerFunction);
    }

    public static <I, O> JMConcurrentTransformProcessor<I, O> buildWithThreadPool(Executor executor, int maxBufferCapacity, Function<I, O> transformerFunction) {
        return new JMConcurrentTransformProcessor<I, O>(executor, maxBufferCapacity, transformerFunction);
    }

    public static <T, M, R> JMTransformProcessorInterface<T, R> buildCombine(Function<T, M> transformerFunction1, Function<M, R> transformerFunction2) {
        return JMTransformProcessorBuilder.build(t -> transformerFunction2.apply(transformerFunction1.apply(t)));
    }
}

