/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.processor;

import java.util.concurrent.Flow;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kr.jm.utils.flow.processor.JMTransformProcessorInterface;
import kr.jm.utils.flow.publisher.JMSubmissionPublisher;
import kr.jm.utils.flow.subscriber.JMSubscriber;
import kr.jm.utils.flow.subscriber.JMSubscriberBuilder;
import kr.jm.utils.helper.JMLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMTransformProcessor<T, R>
implements JMTransformProcessorInterface<T, R> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private JMSubscriber<T> inputSubscriber;
    private JMSubmissionPublisher<R> outputPublisher = new JMSubmissionPublisher();

    public JMTransformProcessor(Function<T, R> transformerFunction) {
        this(JMTransformProcessor.getSingleInputPublisherBiConsumer(transformerFunction));
    }

    protected static <I, O> BiConsumer<I, JMSubmissionPublisher<? super O>> getSingleInputPublisherBiConsumer(Function<I, O> transformerFunction) {
        return (i, s) -> s.submit(transformerFunction.apply(i));
    }

    public JMTransformProcessor(BiConsumer<T, JMSubmissionPublisher<? super R>> outputPublisherBiConsumer) {
        this.inputSubscriber = JMSubscriberBuilder.build(t -> outputPublisherBiConsumer.accept(t, this.outputPublisher));
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        JMLog.info((Logger)this.log, (String)"onSubscribe", (Object[])new Object[]{subscription});
        this.inputSubscriber.onSubscribe(subscription);
    }

    @Override
    public void onNext(T item) {
        JMLog.debug((Logger)this.log, (String)"onNext", (Object[])new Object[]{item});
        this.inputSubscriber.onNext(item);
    }

    @Override
    public void onError(Throwable throwable) {
        this.inputSubscriber.onError(throwable);
    }

    @Override
    public void onComplete() {
        JMLog.info((Logger)this.log, (String)"onComplete");
        this.inputSubscriber.onComplete();
    }

    @Override
    public void subscribe(Flow.Subscriber<? super R> subscriber) {
        JMLog.info((Logger)this.log, (String)"subscribeWith", (Object[])new Object[]{subscriber});
        this.outputPublisher.subscribe(subscriber);
    }
}

