/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kr.jm.utils.helper.JMJson;
import kr.jm.utils.helper.JMOptional;
import kr.jm.utils.helper.JMPredicate;
import kr.jm.utils.helper.JMRestfulResource;
import kr.jm.utils.helper.JMThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulResourceUpdater<T> {
    private static final Logger log = LoggerFactory.getLogger(RestfulResourceUpdater.class);
    private String restfulResourceUrl;
    private TypeReference<T> typeReference;
    private String cachedJsonString;
    private T cachedResource;

    public RestfulResourceUpdater(String restfulResourceUrl) {
        this(restfulResourceUrl, 0);
    }

    public RestfulResourceUpdater(String restfulResourceUrl, int periodSeconds) {
        this(restfulResourceUrl, periodSeconds, 0L);
    }

    public RestfulResourceUpdater(String restfulResourceUrl, int periodSeconds, long initialDelayMillis) {
        this(restfulResourceUrl, periodSeconds, initialDelayMillis, null);
    }

    public RestfulResourceUpdater(String restfulResourceUrl, int periodSeconds, long initialDelayMillis, Consumer<T> updateConsumer) {
        this.restfulResourceUrl = restfulResourceUrl;
        this.typeReference = new TypeReference<T>(){};
        if (periodSeconds > 0) {
            JMThread.runWithScheduleAtFixedRate((long)initialDelayMillis, (long)TimeUnit.SECONDS.toMillis(periodSeconds), () -> Optional.ofNullable(updateConsumer).ifPresentOrElse(this::updateResource, this::updateResourceWithLog));
        }
    }

    public Optional<T> updateResourceWithLog() {
        Optional<T> resourceAsOpt = this.updateResource();
        log.debug("Updated Resource - {}", (Object)(this.updateResource().isPresent() ? "YES" : "NO"));
        return resourceAsOpt;
    }

    public Optional<T> updateResource() {
        return JMOptional.getOptional((String)JMRestfulResource.getStringWithRestOrClasspathOrFilePath(this.restfulResourceUrl)).filter(JMPredicate.getEquals((Object)this.cachedJsonString).negate()).filter(JMPredicate.peek(this::setJsonStringCache)).map(jsonString -> JMJson.withJsonString(jsonString, this.typeReference)).filter(JMPredicate.peek(resource -> {
            this.cachedResource = resource;
        }));
    }

    public void updateResource(Consumer<T> updateConsumer) {
        this.updateResourceWithLog().ifPresent(updateConsumer);
    }

    private void setJsonStringCache(String jsonStringCache) {
        this.cachedJsonString = jsonStringCache;
    }

    public String getRestfulResourceUrl() {
        return this.restfulResourceUrl;
    }

    public TypeReference<T> getTypeReference() {
        return this.typeReference;
    }

    public String getCachedJsonString() {
        return this.cachedJsonString;
    }

    public T getCachedResource() {
        return this.cachedResource;
    }
}

