/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.stats.collector;

import java.util.List;
import java.util.Map;
import kr.jm.utils.helper.JMString;
import kr.jm.utils.stats.collector.NumberItemCollector;
import kr.jm.utils.stats.collector.WordItemCollector;

public class WordNumberCollectorBundle {
    private String collectorId;
    private WordItemCollector wordCollector;
    private NumberItemCollector numberCollector;

    public WordNumberCollectorBundle(String collectorId) {
        this.collectorId = collectorId;
        this.wordCollector = new WordItemCollector();
        this.numberCollector = new NumberItemCollector();
    }

    private WordNumberCollectorBundle() {
    }

    public String getCollectorId() {
        return this.collectorId;
    }

    public WordNumberCollectorBundle addWord(String key, String word) {
        this.wordCollector.add(key, word);
        return this;
    }

    public WordNumberCollectorBundle addWordList(String key, List<String> wordList) {
        this.wordCollector.addAll(key, wordList);
        return this;
    }

    public Map<String, Map<String, Long>> buildWordCountMetricsMap() {
        return this.wordCollector.extractCollectingMap();
    }

    public WordNumberCollectorBundle addNumber(String key, Number number) {
        this.numberCollector.add(key, number);
        return this;
    }

    public WordNumberCollectorBundle addNumberList(String key, List<Number> numberList) {
        this.numberCollector.addAll(key, numberList);
        return this;
    }

    public Map<String, Map<String, Number>> buildNumberStatsMetricsMap() {
        return this.numberCollector.extractCollectingMap();
    }

    public WordNumberCollectorBundle addData(String key, String data) {
        if (JMString.isNumber(data)) {
            this.addNumber(key, Double.valueOf(data));
        } else {
            this.addWord(key, data);
        }
        return this;
    }

    public WordNumberCollectorBundle merge(WordNumberCollectorBundle wordNumberCollector) {
        this.wordCollector.merge(wordNumberCollector.wordCollector);
        this.numberCollector.merge(wordNumberCollector.numberCollector);
        return this;
    }

    public WordNumberCollectorBundle mergeAll(List<WordNumberCollectorBundle> wordNumberCollectorList) {
        for (WordNumberCollectorBundle wordNumberCollector : wordNumberCollectorList) {
            this.merge(wordNumberCollector);
        }
        return this;
    }

    public WordItemCollector getWordCollector() {
        return this.wordCollector;
    }

    public NumberItemCollector getNumberCollector() {
        return this.numberCollector;
    }

    public String toString() {
        return "WordNumberCollectorBundle{collectorId='" + this.collectorId + '\'' + ", wordCollector=" + this.wordCollector + ", numberCollector=" + this.numberCollector + '}';
    }
}

