/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.destroy;

import java.util.Arrays;
import java.util.Collection;
import kr.jm.utils.destroy.DestroyInterface;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMOptional;
import kr.jm.utils.helper.JMThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Destroyer {
    private static final Logger log = LoggerFactory.getLogger(Destroyer.class);

    @SafeVarargs
    public static <D extends DestroyInterface> void cleanUp(D ... destroys) {
        JMOptional.getOptional(destroys).map(Arrays::asList).ifPresent(Destroyer::cleanUp);
    }

    public static <D extends DestroyInterface> void cleanUp(Collection<D> destroyCollection) {
        JMOptional.getOptional(destroyCollection).ifPresent(collection -> collection.forEach(Destroyer::cleanUp));
    }

    public static void cleanUp(DestroyInterface destroy) {
        try {
            JMThread.sleep(10L);
            log.info("Start Clean Up - {}", (Object)destroy);
            destroy.cleanUp();
            log.info("Complete Clean Up - {}", (Object)destroy);
        }
        catch (Exception e) {
            log.error("Fail Clean Up - {}", (Object)destroy);
            JMExceptionManager.handleException(log, e, "cleanUp", destroy);
        }
    }
}

