/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.accumulator;

import java.util.concurrent.atomic.LongAdder;

public class CountBytesSizeAccumulator {
    private LongAdder count = new LongAdder();
    private LongAdder bytesSize = new LongAdder();

    public synchronized void reset() {
        this.count.reset();
        this.bytesSize.reset();
    }

    public void increaseCount() {
        this.count.increment();
    }

    public void accumulateCount(int count) {
        this.count.add(count);
    }

    public void accumulateBytesSize(int bytesSize) {
        this.bytesSize.add(bytesSize);
    }

    public synchronized void accumulate(int count, int bytesSize) {
        this.accumulateCount(count);
        this.accumulateBytesSize(bytesSize);
    }

    public synchronized void increaseCountAccumulateBytes(int bytesSize) {
        this.increaseCount();
        this.accumulateBytesSize(bytesSize);
    }

    public long getCount() {
        return this.count.longValue();
    }

    public long getBytesSize() {
        return this.bytesSize.longValue();
    }
}

