/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.time;

import kr.jm.utils.enums.Milliseconds;
import kr.jm.utils.time.JMTimeUtil;

public class JMTimeCalculator {
    private static final long aSecond = Milliseconds.SECOND.getValue();
    private static final long aMinute = Milliseconds.MINUTE.getValue();
    private static final long anHour = Milliseconds.HOUR.getValue();
    private static final long aDay = Milliseconds.DAY.getValue();
    private static final long aWeek = Milliseconds.WEEK.getValue();

    public static long getTimestampMinusTimestamp(long targetTimestamp, long timestamp) {
        return targetTimestamp - timestamp;
    }

    public static long getCurrentMinusTimestamp(long timeMillis) {
        return System.currentTimeMillis() - timeMillis;
    }

    public static long getCurrentMinusTimestamp(String isoTimestampString) {
        return JMTimeCalculator.getCurrentMinusTimestamp(JMTimeUtil.changeIsoTimestampToLong(isoTimestampString));
    }

    public static long getTimestampMinusParameters(long targetTimestamp, int numOfWeeks, int numOfDays, int numOfHours, int numOfMinutes, int numOfSeconds) {
        long sumOfParameters = (long)numOfWeeks * aWeek + (long)numOfDays * aDay + (long)numOfHours * anHour + (long)numOfMinutes * aMinute + (long)numOfSeconds * aSecond;
        return targetTimestamp - sumOfParameters;
    }

    public static long getCurrentTimestampMinusParameters(int numOfWeeks, int numOfDays, int numOfHours, int numOfMinutes, int numOfSeconds) {
        return JMTimeCalculator.getTimestampMinusParameters(System.currentTimeMillis(), numOfWeeks, numOfDays, numOfHours, numOfMinutes, numOfSeconds);
    }

    public static long getTimestampMinusSeconds(long targetTimestamp, int numOfSeconds) {
        return targetTimestamp - (long)numOfSeconds * aSecond;
    }

    public static long getTimestampMinusMinutes(long targetTimestamp, int numOfMinutes) {
        return targetTimestamp - (long)numOfMinutes * aMinute;
    }

    public static long getTimestampMinusHours(long targetTimestamp, int numOfHours) {
        return targetTimestamp - (long)numOfHours * anHour;
    }

    public static long getTimestampMinusDays(long targetTimestamp, int numOfDays) {
        return targetTimestamp - (long)numOfDays * aDay;
    }

    public static long getTimestampMinusWeeks(long targetTimestamp, int numOfWeeks) {
        return targetTimestamp - (long)numOfWeeks * aWeek;
    }

    public static long getTimestampPlusMinutes(long targetTimestamp, int numOfMinutes) {
        return targetTimestamp + (long)numOfMinutes * aMinute;
    }

    public static long getTimestampPlusHours(long targetTimestamp, int numOfHours) {
        return targetTimestamp + (long)numOfHours * anHour;
    }

    public static long getTimestampPlusDays(long targetTimestamp, int numOfDays) {
        return targetTimestamp + (long)numOfDays * aDay;
    }

    public static long getTimestampPlusWeeks(long targetTimestamp, int numOfWeeks) {
        return targetTimestamp + (long)numOfWeeks * aWeek;
    }
}

