/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.stats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kr.jm.utils.datastructure.JMCollections;
import kr.jm.utils.helper.JMLambda;

public class StringCounter {
    private final List<String> stringList = new ArrayList<String>();

    private StringCounter() {
    }

    public static StringCounter of() {
        return new StringCounter();
    }

    public static Map<String, Long> getCountMap(Collection<String> stringCollection) {
        return Collections.unmodifiableMap(JMLambda.countBy(stringCollection));
    }

    public static List<String> getSortedStringList(Collection<String> stringCollection) {
        return Collections.unmodifiableList(JMCollections.sort(new ArrayList<String>(stringCollection)));
    }

    public StringCounter merge(StringCounter other) {
        return this.addAll(other.stringList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringCounter addAll(Collection<String> stringCollection) {
        List<String> list = this.stringList;
        synchronized (list) {
            this.stringList.addAll(stringCollection);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringCounter add(String string) {
        List<String> list = this.stringList;
        synchronized (list) {
            this.stringList.add(string);
            return this;
        }
    }

    public Map<String, Long> getCountMap() {
        return StringCounter.getCountMap(this.stringList);
    }

    public List<String> getSortedStringList() {
        return StringCounter.getSortedStringList(this.stringList);
    }

    public List<String> getStringList() {
        return Collections.unmodifiableList(this.stringList);
    }

    public long getTotalCount() {
        return this.stringList.size();
    }

    public long getUniqueCount() {
        return this.stringList.stream().distinct().count();
    }

    public String toString() {
        return "StringCounter{stringList=" + this.stringList + '}';
    }
}

