/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.IntPredicate;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kr.jm.utils.datastructure.JMCollections;
import kr.jm.utils.helper.JMOptional;

public class JMStream {
    public static IntStream numberRange(int startInclusive, int endExclusive, int interval) {
        return JMStream.numberRange(startInclusive, endExclusive, interval, n -> n < endExclusive);
    }

    public static IntStream numberRangeClosed(int startInclusive, int endInclusive, int interval) {
        return JMStream.numberRange(startInclusive, endInclusive, interval, n -> n <= endInclusive);
    }

    public static IntStream numberRange(int start, int end, int interval, IntPredicate predicate) {
        return JMStream.numberRangeWithCount(start, interval, (end - start) / interval + 1).filter(predicate);
    }

    public static IntStream numberRangeWithCount(int start, int interval, int count) {
        return IntStream.iterate(start, n -> n + interval).limit(count);
    }

    public static IntStream increaseRange(int size) {
        return IntStream.range(0, size);
    }

    public static <N extends Number> IntStream buildIntStream(Collection<N> numberCollection) {
        return numberCollection.stream().mapToInt(Number::intValue);
    }

    public static <N extends Number> LongStream buildLongStream(Collection<N> numberCollection) {
        return numberCollection.stream().mapToLong(Number::longValue);
    }

    public static <N extends Number> DoubleStream buildDoubleStream(Collection<N> numberCollection) {
        return numberCollection.stream().mapToDouble(Number::doubleValue);
    }

    public static <T> Stream<T> buildReversedStream(Collection<T> collection) {
        return JMCollections.getReversed(collection).stream();
    }

    @SafeVarargs
    public static <T> Stream<T> buildStream(T ... array) {
        return JMOptional.getOptional(array).map(Arrays::stream).orElseGet(Stream::empty);
    }

    public static <T> Stream<T> buildStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> buildStream(Iterator<T> iterator) {
        return JMStream.buildStream(() -> iterator);
    }

    public static <T> Stream<T> buildStream(final Enumeration<T> enumeration) {
        return JMStream.buildStream(new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }
        });
    }

    public static Stream<String> buildTokenStream(String text, String delimiter) {
        return JMStream.buildStream(delimiter == null ? new StringTokenizer(text) : new StringTokenizer(text, delimiter)).map(o -> (String)o);
    }

    public static Stream<String> buildTokenStream(String text) {
        return JMStream.buildTokenStream(text, null);
    }

    public static <T> Stream<T> buildStream(boolean isParallel, Collection<T> collection) {
        return isParallel ? collection.parallelStream() : collection.stream();
    }

    public static <T> Stream<T> buildConcatStream(List<T> sample1, List<T> sample2) {
        return Stream.concat(sample1.stream(), sample2.stream());
    }

    public static DoubleStream buildRandomNumberStream(int count) {
        return IntStream.range(0, count).mapToDouble(i -> Math.random());
    }

    public static <K, V> Stream<Map.Entry<K, V>> buildEntryStream(Map<K, V> map) {
        return JMOptional.getOptional(map).map(Map::entrySet).map(Collection::stream).orElseGet(Stream::empty);
    }

    public static Stream<?> buildStream(Object object) {
        if (object instanceof Collection) {
            return ((Collection)object).stream();
        }
        if (object.getClass().isArray()) {
            return Arrays.stream((Object[])object);
        }
        return Stream.of(object);
    }
}

