/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMInputStream {
    private static final Logger log = LoggerFactory.getLogger(JMInputStream.class);
    private static final String UTF_8 = "UTF-8";

    public static String toString(InputStream inputStream) {
        return JMInputStream.toString(inputStream, UTF_8, new StringBuilder());
    }

    public static String toString(InputStream inputStream, String charsetName) {
        return JMInputStream.toString(inputStream, charsetName, new StringBuilder());
    }

    private static String toString(InputStream inputStream, String charsetName, StringBuilder stringBuilder) {
        try {
            JMInputStream.consumeInputStream(inputStream, charsetName, line -> JMInputStream.appendLine(stringBuilder, line));
            return stringBuilder.toString();
        }
        catch (Exception e) {
            return (String)JMExceptionManager.handleExceptionAndReturnNull(log, e, "toString", inputStream, charsetName);
        }
    }

    private static void appendLine(StringBuilder stringBuilder, String line) {
        stringBuilder.append(line);
        stringBuilder.append(JMString.LINE_SEPARATOR);
    }

    public static List<String> readLines(InputStream inputStream, String charsetName) {
        ArrayList<String> stringList = new ArrayList<String>();
        try {
            JMInputStream.consumeInputStream(inputStream, charsetName, stringList::add);
        }
        catch (Exception e) {
            return JMExceptionManager.handleExceptionAndReturn(log, e, "readLines", Collections::emptyList, inputStream, charsetName);
        }
        return stringList;
    }

    public static List<String> readLines(InputStream inputStream) {
        return JMInputStream.readLines(inputStream, UTF_8);
    }

    public static void consumeInputStream(InputStream inputStream, String charsetName, Consumer<String> consumer) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, charsetName));){
            String line = br.readLine();
            while (line != null) {
                consumer.accept(line);
                line = br.readLine();
            }
        }
        catch (IOException e) {
            JMExceptionManager.handleExceptionAndThrowRuntimeEx(log, e, "consumeInputStream", inputStream, charsetName, consumer);
        }
    }
}

