/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.collections;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import kr.jm.utils.datastructure.JMMap;
import kr.jm.utils.helper.JMOptional;

public class JMNestedMap<K1, K2, V>
implements Map<K1, Map<K2, V>> {
    private Map<K1, Map<K2, V>> nestedMap;

    public JMNestedMap() {
        this.nestedMap = new ConcurrentHashMap<K1, Map<K2, V>>();
    }

    public JMNestedMap(Map<K1, Map<K2, V>> map) {
        this.nestedMap = new ConcurrentHashMap<K1, Map<K2, Map<K2, V>>>(map);
    }

    @Override
    public int size() {
        return this.nestedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nestedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.nestedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.nestedMap.containsValue(value);
    }

    @Override
    public Map<K2, V> get(Object key) {
        return this.nestedMap.get(key);
    }

    @Override
    public Map<K2, V> put(K1 key, Map<K2, V> value) {
        return this.nestedMap.put(key, value);
    }

    @Override
    public Map<K2, V> remove(Object key) {
        return this.nestedMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K1, ? extends Map<K2, V>> m) {
        this.nestedMap.putAll(m);
    }

    @Override
    public void clear() {
        this.nestedMap.clear();
    }

    @Override
    public Set<K1> keySet() {
        return this.nestedMap.keySet();
    }

    @Override
    public Collection<Map<K2, V>> values() {
        return this.nestedMap.values();
    }

    @Override
    public Set<Map.Entry<K1, Map<K2, V>>> entrySet() {
        return this.nestedMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.nestedMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.nestedMap.hashCode();
    }

    public String toString() {
        return this.nestedMap.toString();
    }

    public V put(K1 key1, K2 key2, V value) {
        return this.getOrPutGetNew(key1).put(key2, value);
    }

    public V get(K1 key1, K2 key2) {
        return JMOptional.getOptional(this.nestedMap, key1).map(map -> map.get(key2)).orElse(null);
    }

    public V getOrPutGetNew(K1 key1, K2 key2, Supplier<V> newValueSupplier) {
        return JMMap.getOrPutGetNew(this.getOrPutGetNew(key1), key2, newValueSupplier);
    }

    public Map<K2, V> getOrPutGetNew(K1 key1) {
        return this.getOrPutGetNew(key1, ConcurrentHashMap::new);
    }

    public Map<K2, V> getOrPutGetNew(K1 key1, Supplier<Map<K2, V>> newMapSupplier) {
        return JMMap.getOrPutGetNew(this.nestedMap, key1, newMapSupplier);
    }
}

