/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.collections;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kr.jm.utils.helper.JMOptional;

public class JMCountMap<V>
implements Map<V, Long> {
    private final Map<V, Long> countMap;

    public JMCountMap() {
        this.countMap = new ConcurrentHashMap<V, Long>();
    }

    public JMCountMap(Map<V, Long> map) {
        this.countMap = map;
    }

    @Override
    public int size() {
        return this.countMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.countMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.countMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.countMap.containsValue(value);
    }

    @Override
    public Long get(Object key) {
        return this.countMap.get(key);
    }

    @Override
    public Long put(V key, Long value) {
        return this.countMap.put((Long)key, value);
    }

    @Override
    public Long remove(Object key) {
        return this.countMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends V, ? extends Long> m) {
        this.countMap.putAll(m);
    }

    @Override
    public void clear() {
        this.countMap.clear();
    }

    @Override
    public Set<V> keySet() {
        return this.countMap.keySet();
    }

    @Override
    public Collection<Long> values() {
        return this.countMap.values();
    }

    @Override
    public Set<Map.Entry<V, Long>> entrySet() {
        return this.countMap.entrySet();
    }

    public String toString() {
        return "JMCountMap{countMap=" + this.countMap + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementAndGet(V value) {
        Map<V, Long> map = this.countMap;
        synchronized (map) {
            this.countMap.put((Long)value, this.getCount(value) + 1L);
            return this.countMap.get(value);
        }
    }

    public long getCount(V value) {
        return JMOptional.getOptional(this.countMap, value).orElse(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMCountMap<V> merge(JMCountMap<V> jmCountMap) {
        Map<V, Long> map = this.countMap;
        synchronized (map) {
            jmCountMap.forEach((value, count) -> this.countMap.put((Long)value, this.getCount(value) + count));
            return this;
        }
    }
}

