/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils;

public class AutoStringBuilder {
    private String autoAppendingString;
    private StringBuilder sb;

    public AutoStringBuilder(String autoAppendingString) {
        this.autoAppendingString = autoAppendingString;
        this.sb = new StringBuilder();
    }

    public AutoStringBuilder appendIfExists(Object ... appendingObjects) {
        for (Object object : appendingObjects) {
            if (object == null || "".equals(object)) continue;
            this.append(object.toString());
        }
        return this;
    }

    public AutoStringBuilder append(String string) {
        this.sb.append(string).append(this.autoAppendingString);
        return this;
    }

    public AutoStringBuilder append(String ... strings) {
        for (String s : strings) {
            this.append(s);
        }
        return this;
    }

    public AutoStringBuilder append(Object object) {
        this.sb.append(object.toString()).append(this.autoAppendingString);
        return this;
    }

    public AutoStringBuilder append(Object ... objects) {
        for (Object o : objects) {
            this.append(o);
        }
        return this;
    }

    public StringBuilder getStringBuilder() {
        return this.sb;
    }

    public AutoStringBuilder removeLastAutoAppendingString() {
        this.sb = this.sb.delete(this.sb.length() - this.autoAppendingString.length(), this.sb.length());
        return this;
    }

    public String autoToString() {
        return this.removeLastAutoAppendingString().toString();
    }

    public String toString() {
        return this.sb.toString();
    }
}

