/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.stats;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kr.jm.utils.datastructure.JMMap;
import kr.jm.utils.stats.NumberSummaryStatistics;
import kr.jm.utils.stats.StatsField;

public class StatsMap
implements Map<StatsField, Number> {
    private Map<StatsField, Number> statsFieldNumberMap;

    private StatsMap() {
    }

    public StatsMap(List<Number> numberList) {
        this(NumberSummaryStatistics.of(numberList).getStatsFieldMap());
    }

    public StatsMap(Map<StatsField, Number> statsFieldNumberMap) {
        this.statsFieldNumberMap = new ConcurrentHashMap<StatsField, Number>(statsFieldNumberMap);
    }

    @Override
    public int size() {
        return this.statsFieldNumberMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.statsFieldNumberMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.statsFieldNumberMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.statsFieldNumberMap.containsValue(value);
    }

    @Override
    public Number get(Object key) {
        return this.statsFieldNumberMap.get(key);
    }

    @Override
    public Number put(StatsField key, Number value) {
        return this.statsFieldNumberMap.put(key, value);
    }

    @Override
    public Number remove(Object key) {
        return this.statsFieldNumberMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends StatsField, ? extends Number> m) {
        this.statsFieldNumberMap.putAll(m);
    }

    @Override
    public void clear() {
        this.statsFieldNumberMap.clear();
    }

    @Override
    public Set<StatsField> keySet() {
        return this.statsFieldNumberMap.keySet();
    }

    @Override
    public Collection<Number> values() {
        return this.statsFieldNumberMap.values();
    }

    @Override
    public Set<Map.Entry<StatsField, Number>> entrySet() {
        return this.statsFieldNumberMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.statsFieldNumberMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.statsFieldNumberMap.hashCode();
    }

    public String toString() {
        return this.statsFieldNumberMap.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatsMap merge(StatsMap statsMap) {
        Map<StatsField, Number> map = this.statsFieldNumberMap;
        synchronized (map) {
            this.statsFieldNumberMap.put(StatsField.count, this.statsFieldNumberMap.get((Object)StatsField.count).longValue() + statsMap.get((Object)StatsField.count).longValue());
            this.statsFieldNumberMap.put(StatsField.sum, this.statsFieldNumberMap.get((Object)StatsField.sum).doubleValue() + statsMap.get((Object)StatsField.sum).doubleValue());
            this.statsFieldNumberMap.put(StatsField.min, this.statsFieldNumberMap.get((Object)StatsField.min).doubleValue() < statsMap.get((Object)StatsField.min).doubleValue() ? this.statsFieldNumberMap.get((Object)StatsField.min).doubleValue() : statsMap.get((Object)StatsField.min).doubleValue());
            this.statsFieldNumberMap.put(StatsField.max, this.statsFieldNumberMap.get((Object)StatsField.max).doubleValue() > statsMap.get((Object)StatsField.max).doubleValue() ? this.statsFieldNumberMap.get((Object)StatsField.max).doubleValue() : statsMap.get((Object)StatsField.max).doubleValue());
            this.statsFieldNumberMap.put(StatsField.avg, this.statsFieldNumberMap.get((Object)StatsField.sum).doubleValue() / this.statsFieldNumberMap.get((Object)StatsField.count).doubleValue());
            return this;
        }
    }

    public Map<String, Number> getStatsFieldStringMap() {
        return StatsMap.changeIntoStatsFieldStringMap(this);
    }

    public static Map<String, Number> changeIntoStatsFieldStringMap(StatsMap statsMap) {
        return JMMap.newChangedKeyMap(statsMap, Enum::name);
    }

    public static StatsMap changeIntoStatsMap(Map<String, Number> statsFieldStringMap) {
        return new StatsMap(JMMap.newChangedKeyMap(statsFieldStringMap, StatsField::valueOf));
    }
}

