/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import kr.jm.utils.datastructure.JMCollections;
import kr.jm.utils.datastructure.JMMap;

public class JMTimeSeries<V>
implements Map<Long, V> {
    protected int intervalSeconds;
    protected long intervalMillis;
    protected Map<Long, V> timeSeriesMap;

    public JMTimeSeries(int intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
        this.intervalMillis = intervalSeconds * 1000;
        this.timeSeriesMap = new ConcurrentHashMap<Long, V>();
    }

    public int getIntervalSeconds() {
        return this.intervalSeconds;
    }

    @Override
    public V put(Long timestamp, V object) {
        return this.timeSeriesMap.put(this.buildKeyTimestamp(timestamp), object);
    }

    @Override
    public V get(Object timestamp) {
        return this.timeSeriesMap.get(this.buildKeyTimestamp(timestamp));
    }

    public V getOrPutGetNew(Long timestamp, Supplier<V> newSupplier) {
        return JMMap.getOrPutGetNew(this.timeSeriesMap, this.buildKeyTimestamp(timestamp), newSupplier);
    }

    @Override
    public V remove(Object timestamp) {
        return this.timeSeriesMap.remove(this.buildKeyTimestamp(timestamp));
    }

    public List<Long> getTimestampKeyList() {
        return JMCollections.sort(new ArrayList<Long>(this.keySet()), Comparator.reverseOrder());
    }

    public Map<Long, V> getAll() {
        return new HashMap<Long, V>(this.timeSeriesMap);
    }

    public Long buildKeyTimestamp(Long timestamp) {
        return timestamp - timestamp % this.intervalMillis;
    }

    private Long buildKeyTimestamp(Object timestamp) {
        return timestamp instanceof Long ? this.buildKeyTimestamp((Long)timestamp) : null;
    }

    public String toString() {
        return "JMTimeSeries(intervalSeconds=" + this.getIntervalSeconds() + ", timeSeriesMap=" + this.timeSeriesMap.toString() + ")";
    }

    @Override
    public int size() {
        return this.timeSeriesMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.timeSeriesMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object timestamp) {
        return this.timeSeriesMap.containsKey(this.buildKeyTimestamp(timestamp));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.timeSeriesMap.containsValue(value);
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> m) {
        this.timeSeriesMap.putAll(m);
    }

    @Override
    public void clear() {
        this.timeSeriesMap.clear();
    }

    @Override
    public Set<Long> keySet() {
        return this.timeSeriesMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.timeSeriesMap.values();
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        return this.timeSeriesMap.entrySet();
    }
}

