/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CollectionPrinter {
    public static String listToJSONString(List<?> list) {
        if (list == null || list.size() == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        for (Object o : list) {
            CollectionPrinter.buildAppendString(sb, o).append(',').append(' ');
        }
        return sb.delete(sb.length() - 2, sb.length()).append(']').toString();
    }

    private static StringBuilder buildAppendString(StringBuilder sb, Object o) {
        if (o instanceof String) {
            sb.append('\"').append(o.toString()).append('\"');
        } else if (o instanceof List) {
            sb.append(CollectionPrinter.listToJSONString((List)o));
        } else if (o instanceof Map) {
            sb.append(CollectionPrinter.mapToJSONString((Map)o));
        } else if (o == null) {
            sb.append("null");
        } else {
            sb.append(o.toString());
        }
        return sb;
    }

    public static String mapToJSONString(Map<?, ?> map) {
        if (map == null || map.size() == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> o;
            Map.Entry<?, ?> e = o = iterator.next();
            CollectionPrinter.buildAppendString(sb, e.getKey()).append('=');
            CollectionPrinter.buildAppendString(sb, e.getValue()).append(',').append(' ');
        }
        return sb.delete(sb.length() - 2, sb.length()).append('}').toString();
    }
}

