/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.time;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import kr.jm.utils.datastructure.JMMap;

public class JMTimeUtil {
    private static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    public static final String DEFAULT_ZONE_ID_STRING = DEFAULT_ZONE_ID.getId();
    public static final String UTC = "UTC";
    public static final String ISO_INSTANT_MILLS_Z = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String ISO_OFFSET_DATE_TIME_MILLS = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String ISO_INSTANT_TIMEZONE_NAME = "yyyy-MM-dd'T'HH:mm:ssz";
    public static final String ISO_INSTANT_MILLS_TIMEZONE_NAME = "yyyy-MM-dd'T'HH:mm:ss.SSSz";
    public static final String ISO_LOCAL_DATE_TIME_MILLS = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String BASIC_ISO_DATE_TIME_MILLS_OFFSET = "yyyyMMddHHmmss.SSSZ";
    public static final String BASIC_ISO_DATE_TIME_MILLS_TIMEZONE_NAME = "yyyyMMddHHmmss.SSSz";
    public static final String BASIC_ISO_DATE_TIME_MILLS = "yyyyMMddHHmmss.SSS";
    public static final String ISO_INSTANT = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String ISO_INSTANT_Z = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String ISO_LOCAL_DATE_TIME = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String UTC_0000 = "+0000";
    private static final Pattern isoTimestampZoneInfoPattern = Pattern.compile("[\\+|\\-][0-9]{4}$");
    private static Map<String, SimpleDateFormat> simpleDateFormatMap = new HashMap<String, SimpleDateFormat>();
    private static BiFunction<String, String, Supplier<SimpleDateFormat>> newSimpleDateFormatBuilder = (dateFormat, zoneId) -> () -> JMTimeUtil.setIfzoneId(new SimpleDateFormat((String)dateFormat, Locale.US), zoneId);

    public static String changeIsoTimestampToIsoLocalDateTime(String isoTimestamp) {
        return JMTimeUtil.changeFormatAndTimeZone(isoTimestamp, ISO_LOCAL_DATE_TIME, UTC);
    }

    public static String changeIsoTimestampToIsoInstant(String isoTimestamp) {
        return JMTimeUtil.changeFormatAndTimeZone(isoTimestamp, ISO_INSTANT_Z, UTC);
    }

    public static String getCurrentTimestampInUtc() {
        return JMTimeUtil.getTimeAsDefaultUtcFormat(System.currentTimeMillis());
    }

    public static String getCurrentTimestamp() {
        return JMTimeUtil.getTime(System.currentTimeMillis());
    }

    public static String getCurrentTimestamp(String timeFormat) {
        return JMTimeUtil.getTimeInUTC(System.currentTimeMillis(), timeFormat);
    }

    public static String getCurrentTimestamp(String timeFormat, String zoneId) {
        return JMTimeUtil.getTime(System.currentTimeMillis(), timeFormat, zoneId);
    }

    public static String getTime(long epochTimestamp) {
        return JMTimeUtil.getTimeAsLongFormatWithPlusTimezone(epochTimestamp);
    }

    public static String getTimeAsDefaultUtcFormat(long epochTimestamp) {
        return JMTimeUtil.getTimeInUTC(epochTimestamp, ISO_INSTANT_MILLS_Z);
    }

    public static String getTimeAsLongFormatWithPlusTimezone(long epochTimestamp) {
        return JMTimeUtil.getTime(epochTimestamp, ISO_OFFSET_DATE_TIME_MILLS);
    }

    public static String getTimeAsLongFormatWithTimezone(long epochTimestamp) {
        return JMTimeUtil.getTime(epochTimestamp, ISO_INSTANT_MILLS_TIMEZONE_NAME);
    }

    public static String getTimeAsLongFormatWithoutTimezone(long epochTimestamp) {
        return JMTimeUtil.getTime(epochTimestamp, ISO_LOCAL_DATE_TIME_MILLS);
    }

    public static String getTimeAsShortFormatWithPlusTimezone(long epochTimestamp) {
        return JMTimeUtil.getTime(epochTimestamp, BASIC_ISO_DATE_TIME_MILLS_OFFSET);
    }

    public static String getTimeAsShortFormatWithTimezone(long epochTimestamp) {
        return JMTimeUtil.getTime(epochTimestamp, BASIC_ISO_DATE_TIME_MILLS_TIMEZONE_NAME);
    }

    public static String getTimeAsShortFormatWithoutTimezone(long epochTimestamp) {
        return JMTimeUtil.getTime(epochTimestamp, BASIC_ISO_DATE_TIME_MILLS);
    }

    public static String getTimeInUTC(long epochTimestamp, String timeFormat) {
        return JMTimeUtil.getTime(epochTimestamp, timeFormat, UTC);
    }

    public static String getTime(long epochTimestamp, String timeFormat) {
        return JMTimeUtil.getTime(epochTimestamp, timeFormat, DEFAULT_ZONE_ID);
    }

    public static String getTime(long epochTimestamp, String timeFormat, String zoneId) {
        return JMTimeUtil.getTime(epochTimestamp, timeFormat, ZoneId.of(zoneId));
    }

    public static String getTime(long epochTimestamp, String timeFormat, ZoneId zoneId) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochTimestamp), zoneId).format(DateTimeFormatter.ofPattern(timeFormat));
    }

    public static String changeIsoTimestampInUTC(String isoTimestamp) {
        return JMTimeUtil.getTimeAsDefaultUtcFormat(JMTimeUtil.changeIsoTimestampToLong(isoTimestamp));
    }

    public static String changeFormatAndTimeZone(String isoTimestamp, String toBeTimeFormat, String zoneId) {
        return JMTimeUtil.getTime(JMTimeUtil.changeIsoTimestampToLong(isoTimestamp, zoneId), toBeTimeFormat, zoneId);
    }

    public static String changeFormatAndTimeZone(String isoTimestamp, String toBeTimeFormat) {
        return JMTimeUtil.changeFormatAndTimeZone(isoTimestamp, toBeTimeFormat, DEFAULT_ZONE_ID_STRING);
    }

    public static long changeIsoTimestampToLong(String isoTimestamp) {
        try {
            return ZonedDateTime.parse(isoTimestamp).toInstant().toEpochMilli();
        }
        catch (Exception e) {
            return JMTimeUtil.changeIsoTimestampToLong(isoTimestamp, DEFAULT_ZONE_ID_STRING);
        }
    }

    public static long changeIsoTimestampToLong(String isoTimestamp, String zoneId) {
        try {
            return LocalDateTime.parse(isoTimestamp).atZone(ZoneId.of(zoneId)).toInstant().toEpochMilli();
        }
        catch (Exception e) {
            isoTimestamp = JMTimeUtil.changeZTo0000(isoTimestamp);
            return JMTimeUtil.changeTimestampToLong(JMTimeUtil.getTimeFormat(isoTimestamp), isoTimestamp, zoneId);
        }
    }

    private static String changeZTo0000(String isoTimestamp) {
        int index = isoTimestamp.length() - 1;
        char lastChar = isoTimestamp.charAt(index);
        return lastChar == 'Z' || lastChar == 'z' ? isoTimestamp.substring(0, index) + UTC_0000 : isoTimestamp;
    }

    private static String getTimeFormat(String isoTimestamp) {
        boolean isContainsDot = isoTimestamp.contains(".");
        boolean isContainsPlusOrMinus = isoTimestampZoneInfoPattern.matcher(isoTimestamp).find();
        int length = isoTimestamp.length();
        if (isContainsDot && isContainsPlusOrMinus && length == 28) {
            return ISO_OFFSET_DATE_TIME_MILLS;
        }
        if (isContainsDot && !isContainsPlusOrMinus) {
            if (length == 26) {
                return ISO_INSTANT_MILLS_TIMEZONE_NAME;
            }
            if (length == 23) {
                return ISO_LOCAL_DATE_TIME_MILLS;
            }
            if (length == 22) {
                return ISO_INSTANT_TIMEZONE_NAME;
            }
        } else {
            if (!isContainsDot && !isContainsPlusOrMinus && length == 19) {
                return ISO_LOCAL_DATE_TIME;
            }
            if (!isContainsDot && isContainsPlusOrMinus && length == 24) {
                return ISO_INSTANT;
            }
        }
        throw new RuntimeException("Don't Support Format ISO Timestamp!!! - " + isoTimestamp);
    }

    private static SimpleDateFormat getSimpleDateFormat(String dateFormat) {
        return JMTimeUtil.getSimpleDateFormat(dateFormat, null);
    }

    private static SimpleDateFormat getSimpleDateFormat(String dateFormat, String zoneId) {
        return JMMap.getOrPutGetNew(simpleDateFormatMap, JMTimeUtil.buildSimpleDateFormatKey(dateFormat, zoneId), newSimpleDateFormatBuilder.apply(dateFormat, zoneId));
    }

    private static String buildSimpleDateFormatKey(String dateFormat, String zoneId) {
        return dateFormat + zoneId;
    }

    public static long changeTimestampToLong(String dateFormat, String timestamp, String zoneId) {
        return JMTimeUtil.changeTimestampToLong(JMTimeUtil.getSimpleDateFormat(dateFormat, zoneId), timestamp);
    }

    public static long changeTimestampToLong(String dateFormat, String timestamp) {
        return JMTimeUtil.changeTimestampToLong(JMTimeUtil.getSimpleDateFormat(dateFormat), timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long changeTimestampToLong(SimpleDateFormat simpleDateFormat, String timestamp) {
        try {
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            synchronized (simpleDateFormat2) {
                return simpleDateFormat.parse(timestamp).getTime();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String changeTimestampToNewFormat(String dateFormat, String timestamp, String newDateFormat) {
        return JMTimeUtil.getTime(JMTimeUtil.changeTimestampToLong(JMTimeUtil.getSimpleDateFormat(dateFormat), timestamp), newDateFormat);
    }

    public static String changeTimestampToNewFormat(String isoTimestamp, ZoneId zoneID, DateTimeFormatter newFormat) {
        return ZonedDateTime.parse(isoTimestamp).withZoneSameInstant(zoneID).format(newFormat);
    }

    public static String changeTimestampToNewFormatWithDefaultZoneId(String isoTimestamp, DateTimeFormatter newFormat) {
        return JMTimeUtil.changeTimestampToNewFormat(isoTimestamp, DEFAULT_ZONE_ID, newFormat);
    }

    public static String changeTimestampToNewFormat(String isoTimestamp, DateTimeFormatter newFormat) {
        return ZonedDateTime.parse(isoTimestamp).format(newFormat);
    }

    public static String changeTimestampToIsoInstant(String dateFormat, String timestamp) {
        return JMTimeUtil.getTime(JMTimeUtil.changeTimestampToLong(JMTimeUtil.getSimpleDateFormat(dateFormat), timestamp), ISO_INSTANT_Z, UTC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat setIfzoneId(SimpleDateFormat simpleDateFormat, String zoneId) {
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
        synchronized (simpleDateFormat2) {
            if (zoneId != null) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(zoneId));
            }
            return simpleDateFormat;
        }
    }

    public static long getTimeMillis(int year, int month, int dayOfMonth, int hour, int minute, int second, int mills, String zoneId) {
        return ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, new Long(TimeUnit.MILLISECONDS.toNanos(mills)).intValue(), ZoneId.of(zoneId)).toInstant().toEpochMilli();
    }

    public static long getTimeMillisWithNano(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond, String zoneId) {
        return ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, ZoneId.of(zoneId)).toInstant().toEpochMilli();
    }

    public static long getTimeMillis(int year, int month, int dayOfMonth, int hour, int minute, int second, String zoneId) {
        return ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, 0, ZoneId.of(zoneId)).toInstant().toEpochMilli();
    }

    public static long getTimeMillis(int year, int month, int dayOfMonth, int hour, int minute, String zoneId) {
        return JMTimeUtil.getTimeMillis(year, month, dayOfMonth, hour, minute, 0, zoneId);
    }

    public static long getTimeMillis(int year, int month, int dayOfMonth, int hour, String zoneId) {
        return JMTimeUtil.getTimeMillis(year, month, dayOfMonth, hour, 0, 0, zoneId);
    }

    public static long getTimeMillis(int year, int month, int dayOfMonth, String zoneId) {
        return JMTimeUtil.getTimeMillis(year, month, dayOfMonth, 0, 0, 0, zoneId);
    }

    public static long getTimeMillis(int year, int month, String zoneId) {
        return JMTimeUtil.getTimeMillis(year, month, 0, 0, 0, 0, zoneId);
    }

    public static long getTimeMillis(int year, String zoneId) {
        return JMTimeUtil.getTimeMillis(year, 0, 0, 0, 0, 0, zoneId);
    }

    public static ZonedDateTime getZonedDataTime(long timestamp, String zoneId) {
        return Instant.ofEpochMilli(timestamp).atZone(ZoneId.of(zoneId));
    }

    public static ZonedDateTime getZonedDataTime(long timestamp) {
        return Instant.ofEpochMilli(timestamp).atZone(DEFAULT_ZONE_ID);
    }

    public static OffsetDateTime getOffsetDateTime(long timestamp, String zoneOffsetId) {
        return Instant.ofEpochMilli(timestamp).atOffset(ZoneOffset.of(zoneOffsetId));
    }

    public static OffsetDateTime getOffsetDateTime(long timestamp) {
        return Instant.ofEpochMilli(timestamp).atOffset(ZoneOffset.of(DEFAULT_ZONE_ID_STRING));
    }
}

