/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMFile {
    private static final Logger log = LoggerFactory.getLogger(JMFile.class);

    public static boolean writeString(String inputString, File targetFile) {
        if (!targetFile.exists()) {
            try {
                Files.write(targetFile.toPath(), inputString.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                return JMExceptionManager.handleExceptionAndReturnFalse(log, e, "writeString", inputString, targetFile);
            }
        }
        return true;
    }

    public static String readString(File targetFile) {
        try {
            return new String(Files.readAllBytes(targetFile.toPath()));
        }
        catch (IOException e) {
            return (String)JMExceptionManager.handleExceptionAndReturnNull(log, e, "readString", targetFile);
        }
    }

    public static String readString(File targetFile, String encoding) {
        try {
            return new String(Files.readAllBytes(targetFile.toPath()), Charset.forName(encoding));
        }
        catch (IOException e) {
            return (String)JMExceptionManager.handleExceptionAndReturnNull(log, e, "readString", targetFile);
        }
    }

    public static String readString(String filePath) {
        return JMFile.readString(JMFile.getFile(filePath));
    }

    public static String readString(String filePath, String encoding) {
        return JMFile.readString(JMFile.getFile(filePath), encoding);
    }

    public static List<String> readLines(File targetFile) {
        try {
            return Files.readAllLines(targetFile.toPath());
        }
        catch (IOException e) {
            return (List)JMExceptionManager.handleExceptionAndReturnNull(log, e, "readLines", targetFile);
        }
    }

    public static List<String> readLines(File targetFile, String encoding) {
        try {
            return Files.readAllLines(targetFile.toPath(), Charset.forName(encoding));
        }
        catch (IOException e) {
            return (List)JMExceptionManager.handleExceptionAndReturnNull(log, e, "readLines", targetFile);
        }
    }

    public static List<String> readLines(String filePath) {
        return JMFile.readLines(JMFile.getFile(filePath));
    }

    public static List<String> readLines(String filePath, String encoding) {
        return JMFile.readLines(JMFile.getFile(filePath), encoding);
    }

    private static File getFile(String filePath) {
        return new File(filePath);
    }

    public static String getExtension(File file) {
        return JMString.getExtension(file.getName());
    }

    public static String getPrefix(File file) {
        return JMString.getPrefixOfFileName(file.getName());
    }

    public static String[] getPrefixSuffix(File file) {
        return JMString.splitFileNameIntoPreSuffix(file.getName());
    }

    public static File createTempFile(File file) {
        String[] prefixSuffix = JMFile.getPrefixSuffix(file);
        try {
            File tempFile = File.createTempFile(prefixSuffix[0], prefixSuffix[1]);
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (Exception e) {
            return (File)JMExceptionManager.handleExceptionAndReturnNull(log, e, "createTempFile", file);
        }
    }
}

