/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import kr.jm.utils.datastructure.JMCollections;
import kr.jm.utils.datastructure.JMMap;

public class JMTimeseries<V>
implements Map<Long, V> {
    long intervalMillis;
    Map<Long, V> timeseriesMap;

    public JMTimeseries(long intervalSeconds) {
        this.intervalMillis = intervalSeconds * 1000L;
        this.timeseriesMap = new ConcurrentHashMap<Long, V>();
    }

    public long getIntervalSeconds() {
        return this.intervalMillis / 1000L;
    }

    @Override
    public V put(Long timestamp, V object) {
        return this.timeseriesMap.put(this.buildKeyTimetamp(timestamp), object);
    }

    @Override
    public V get(Object timestamp) {
        return this.timeseriesMap.get(this.buildKeyTimetamp(timestamp));
    }

    public V getOrNew(Long timestamp, Supplier<V> newSupplier) {
        return JMMap.getOrPutGetNew(this.timeseriesMap, this.buildKeyTimetamp(timestamp), newSupplier);
    }

    @Override
    public V remove(Object timestamp) {
        return this.timeseriesMap.remove(this.buildKeyTimetamp(timestamp));
    }

    public List<Long> getTimestampKeyList() {
        return JMCollections.sort(new ArrayList<Long>(this.keySet()), (l1, l2) -> l2.compareTo((Long)l1));
    }

    public Map<Long, V> getAll() {
        return new HashMap<Long, V>(this.timeseriesMap);
    }

    public Long buildKeyTimetamp(Long timestamp) {
        return timestamp - timestamp % this.intervalMillis;
    }

    private Long buildKeyTimetamp(Object timestamp) {
        return timestamp instanceof Long ? this.buildKeyTimetamp((Long)timestamp) : null;
    }

    public String toString() {
        return "JMTimeseries(intervalSeconds=" + this.getIntervalSeconds() + ", timeseriesMap=" + this.timeseriesMap.toString() + ")";
    }

    @Override
    public int size() {
        return this.timeseriesMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.timeseriesMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object timestamp) {
        return this.timeseriesMap.containsKey(this.buildKeyTimetamp(timestamp));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.timeseriesMap.containsValue(value);
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> m) {
        this.timeseriesMap.putAll(m);
    }

    @Override
    public void clear() {
        this.timeseriesMap.clear();
    }

    @Override
    public Set<Long> keySet() {
        return this.timeseriesMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.timeseriesMap.values();
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        return this.timeseriesMap.entrySet();
    }
}

