/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMFile;
import kr.jm.utils.helper.JMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMResources {
    private static final Logger log = LoggerFactory.getLogger(JMResources.class);

    public static void setSystemPropertyIfIsNull(String key, Object value) {
        if (!System.getProperties().containsKey(key)) {
            System.setProperty(key, value.toString());
        }
    }

    public static String getSystemProperty(String key) {
        return System.getProperty(key);
    }

    public static URL getResourceURL(String classpath) {
        return ClassLoader.getSystemResource(classpath);
    }

    public static URL getURL(String classpathOrFilePath) {
        try {
            return JMResources.getURI(classpathOrFilePath).toURL();
        }
        catch (MalformedURLException e) {
            return (URL)JMExceptionManager.handleExceptionAndReturnNull(log, e, "getURL", classpathOrFilePath);
        }
    }

    public static URI getResourceURI(String classpath) {
        try {
            return JMResources.getResourceURL(classpath).toURI();
        }
        catch (Exception e) {
            return (URI)JMExceptionManager.handleExceptionAndReturnNull(log, e, "getResourceURI", classpath);
        }
    }

    public static URI getURI(String classpathOrFilePath) {
        return Optional.ofNullable(JMResources.getResourceURI(classpathOrFilePath)).orElseGet(() -> new File(classpathOrFilePath).toURI());
    }

    public static InputStream getResourceInputStream(String classpath) {
        return ClassLoader.getSystemResourceAsStream(classpath);
    }

    public static Properties getProperties(String classpath) {
        Properties properties = new Properties();
        InputStream is = JMResources.getResourceInputStream(classpath);
        try {
            properties.load(is);
            is.close();
        }
        catch (IOException e) {
            return (Properties)JMExceptionManager.handleExceptionAndReturnNull(log, e, "getProperties", classpath);
        }
        return properties;
    }

    public static Properties getProperties(File propertiesFile) {
        Properties properties = new Properties();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(propertiesFile));
            properties.load(reader);
            reader.close();
        }
        catch (IOException e) {
            JMExceptionManager.logException(log, e, "getProperties", propertiesFile);
        }
        return properties;
    }

    public static boolean saveProperties(Properties inProperties, File saveFile, String comment) {
        try {
            if (!saveFile.exists()) {
                saveFile.getParentFile().mkdirs();
                saveFile.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(saveFile));
            inProperties.store(writer, comment);
            writer.close();
            return true;
        }
        catch (IOException e) {
            return JMExceptionManager.handleExceptionAndReturnFalse(log, e, "saveProperties", inProperties, saveFile, comment);
        }
    }

    public static String readString(String resourceClasspath) {
        return JMInputStream.toString(JMResources.getResourceInputStream(resourceClasspath));
    }

    public static String readString(String resourceClasspath, String encoding) {
        return JMInputStream.toString(JMResources.getResourceInputStream(resourceClasspath), encoding);
    }

    public static List<String> readLines(String resourceClasspath) {
        return JMInputStream.readLines(JMResources.getResourceInputStream(resourceClasspath));
    }

    public static List<String> readLines(String resourceClasspath, String encoding) {
        return JMInputStream.readLines(JMResources.getResourceInputStream(resourceClasspath), encoding);
    }

    public static String getStringFromClasspathOrFilePath(String classpathOrFilePath) {
        InputStream resourceInputStream = JMResources.getResourceInputStream(classpathOrFilePath);
        return resourceInputStream != null ? JMInputStream.toString(resourceInputStream) : JMFile.readString(classpathOrFilePath);
    }

    public static String getStringFromClasspathOrFilePath(String classpathOrFilePath, String encoding) {
        InputStream resourceInputStream = JMResources.getResourceInputStream(classpathOrFilePath);
        return resourceInputStream != null ? JMInputStream.toString(resourceInputStream, encoding) : JMFile.readString(classpathOrFilePath, encoding);
    }

    public static List<String> readLinesFromClasspathOrFilePath(String classpathOrFilePath) {
        InputStream resourceInputStream = JMResources.getResourceInputStream(classpathOrFilePath);
        return resourceInputStream != null ? JMInputStream.readLines(resourceInputStream) : JMFile.readLines(classpathOrFilePath);
    }

    public static ResourceBundle getResourceBundle(String baseName) {
        return ResourceBundle.getBundle(baseName);
    }

    public static ResourceBundle getResourceBundle(String baseName, Locale targetLocale) {
        Locale.setDefault(targetLocale);
        return ResourceBundle.getBundle(baseName);
    }
}

