/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.enums;

import java.util.Arrays;
import java.util.DoubleSummaryStatistics;
import java.util.IntSummaryStatistics;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import kr.jm.utils.helper.JMLambda;

public enum StatsField {
    sum,
    min,
    max,
    avg,
    count;


    public static StatsField valueOfAlias(String alias) {
        switch (alias.toLowerCase()) {
            case "summary": {
                return sum;
            }
            case "minimum": {
                return min;
            }
            case "maximum": {
                return max;
            }
            case "average": {
                return avg;
            }
        }
        return StatsField.valueOf(alias);
    }

    public Number calStats(IntStream intStream) {
        switch (this) {
            case sum: {
                return intStream.sum();
            }
            case min: {
                return intStream.min().orElse(0);
            }
            case max: {
                return intStream.max().orElse(0);
            }
            case count: {
                return intStream.count();
            }
            case avg: {
                return intStream.average().orElse(0.0);
            }
        }
        return 0;
    }

    public Number calStats(LongStream longStream) {
        switch (this) {
            case sum: {
                return longStream.sum();
            }
            case min: {
                return longStream.min().orElse(0L);
            }
            case max: {
                return longStream.max().orElse(0L);
            }
            case count: {
                return longStream.count();
            }
            case avg: {
                return longStream.average().orElse(0.0);
            }
        }
        return 0L;
    }

    public Number calStats(DoubleStream doubleStream) {
        switch (this) {
            case sum: {
                return doubleStream.sum();
            }
            case min: {
                return doubleStream.min().orElse(0.0);
            }
            case max: {
                return doubleStream.max().orElse(0.0);
            }
            case count: {
                return doubleStream.count();
            }
            case avg: {
                return doubleStream.average().orElse(0.0);
            }
        }
        return 0.0;
    }

    public Number calStats(IntSummaryStatistics summaryStatistics) {
        switch (this) {
            case sum: {
                return summaryStatistics.getSum();
            }
            case min: {
                return summaryStatistics.getMin();
            }
            case max: {
                return summaryStatistics.getMax();
            }
            case count: {
                return summaryStatistics.getCount();
            }
            case avg: {
                return summaryStatistics.getAverage();
            }
        }
        return 0;
    }

    public Number calStats(LongSummaryStatistics summaryStatistics) {
        switch (this) {
            case sum: {
                return summaryStatistics.getSum();
            }
            case min: {
                return summaryStatistics.getMin();
            }
            case max: {
                return summaryStatistics.getMax();
            }
            case count: {
                return summaryStatistics.getCount();
            }
            case avg: {
                return summaryStatistics.getAverage();
            }
        }
        return 0L;
    }

    public Number calStats(DoubleSummaryStatistics summaryStatistics) {
        switch (this) {
            case sum: {
                return summaryStatistics.getSum();
            }
            case min: {
                return summaryStatistics.getMin();
            }
            case max: {
                return summaryStatistics.getMax();
            }
            case count: {
                return summaryStatistics.getCount();
            }
            case avg: {
                return summaryStatistics.getAverage();
            }
        }
        return 0.0;
    }

    public static Map<StatsField, Number> calStatsMap(IntSummaryStatistics summaryStatistics) {
        return StatsField.buildStatsMap(statsField -> statsField.calStats(summaryStatistics));
    }

    public static Map<StatsField, Number> calStatsMap(LongSummaryStatistics summaryStatistics) {
        return StatsField.buildStatsMap(statsField -> statsField.calStats(summaryStatistics));
    }

    public static Map<StatsField, Number> calStatsMap(DoubleSummaryStatistics summaryStatistics) {
        return StatsField.buildStatsMap(statsField -> statsField.calStats(summaryStatistics));
    }

    private static Map<StatsField, Number> buildStatsMap(Function<StatsField, Number> valueMapper) {
        return Arrays.stream(StatsField.values()).collect(Collectors.toMap(JMLambda.getSelf(), valueMapper));
    }
}

