/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils;

import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import kr.jm.utils.datastructure.JMMap;
import kr.jm.utils.enums.OS;
import kr.jm.utils.helper.JMOptional;
import kr.jm.utils.helper.JMPath;
import kr.jm.utils.helper.JMPathOperation;

public class JMIconFactory {
    private OS os = OS.getOS();
    private String unknownFileName = "?";
    private Map<String, BufferedImage> bufferedImageCache = new ConcurrentHashMap<String, BufferedImage>();

    public JMIconFactory() {
        BufferedImage unknownBufferedImage = this.buildBufferedImageOfIconInOS(JMPath.getPath(this.unknownFileName));
        this.bufferedImageCache.put(this.unknownFileName, unknownBufferedImage);
        if (this.os.equals((Object)OS.MAC)) {
            this.bufferedImageCache.put("/dev", this.buildBufferedImageOfIconInOS(JMPath.getCurrentPath()));
        }
    }

    private Function<String, BufferedImage> getCachedBufferedImageFunction(Path path) {
        Supplier<BufferedImage> newValueSupplier = () -> this.buildBufferedImageOfIconInOS(path);
        return key -> (BufferedImage)((Object)JMMap.getOrPutGetNew(this.bufferedImageCache, key, newValueSupplier));
    }

    private String buildFileExtensionKey(String extension) {
        return this.unknownFileName + extension;
    }

    public BufferedImage buildBufferedImageOfIconInOS(Path path) {
        path = JMOptional.getNullableAndFilteredOptional(path, JMPath.NotExistFilter).flatMap(JMPathOperation::createTempFilePathAsOpt).orElse(path);
        Icon iconInOS = this.os.getIcon(path.toFile());
        BufferedImage bufferedImage = new BufferedImage(iconInOS.getIconWidth(), iconInOS.getIconHeight(), 2);
        iconInOS.paintIcon(null, bufferedImage.getGraphics(), 0, 0);
        return bufferedImage;
    }

    public BufferedImage getCachedBufferedImageOfIconInOS(Path path) {
        return this.getSpecialPathAsOpt(path).map(this.getCachedBufferedImageFunction(path)).orElseGet(() -> this.buildCachedBufferedImageOfFileIconInOS(path));
    }

    private Optional<String> getSpecialPathAsOpt(Path path) {
        return JMOptional.getNullableAndFilteredOptional(path, JMPath.DirectoryFilter.or(JMPath.SymbolicLinkFilter).or(JMPath.HiddenFilter)).map(Path::toAbsolutePath).map(Path::toString);
    }

    private BufferedImage buildCachedBufferedImageOfFileIconInOS(Path path) {
        return this.getFilePathExtensionKeyAsOpt(path).map(this.getCachedBufferedImageFunction(path)).orElseGet(() -> this.bufferedImageCache.get(this.unknownFileName));
    }

    private Optional<String> getFilePathExtensionKeyAsOpt(Path path) {
        return JMPath.getFilePathExtensionAsOpt(path).map(this::buildFileExtensionKey);
    }
}

