/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kr.jm.utils.helper.JMLambda;

public class JMPredicate {
    public static <T> Predicate<T> getTrue() {
        return target -> Boolean.TRUE;
    }

    public static <T> Predicate<T> getFalse() {
        return target -> Boolean.FALSE;
    }

    public static <T> Predicate<T> getBoolean(boolean bool) {
        return target -> bool;
    }

    public static Predicate<Number> getGreater(Number target) {
        return number -> number.doubleValue() > target.doubleValue();
    }

    public static Predicate<Number> getGreaterOrEqual(Number target) {
        return number -> number.doubleValue() >= target.doubleValue();
    }

    public static Predicate<Number> getLess(Number target) {
        return number -> number.doubleValue() < target.doubleValue();
    }

    public static Predicate<Number> getLessOrEqual(Number target) {
        return number -> number.doubleValue() <= target.doubleValue();
    }

    public static Predicate<Collection<?>> getGreaterSize(int target) {
        return collection -> JMPredicate.getGreater(target).test(collection.size());
    }

    public static Predicate<Map<?, ?>> getGreaterMapSize(int target) {
        return map -> JMPredicate.getGreater(target).test(map.size());
    }

    public static Predicate<Object[]> getGreaterLength(int target) {
        return array -> JMPredicate.getGreater(target).test(((Object[])array).length);
    }

    public static Predicate<Collection<?>> getGreaterOrEqualSize(int target) {
        return collection -> JMPredicate.getGreaterOrEqual(target).test(collection.size());
    }

    public static Predicate<Map<?, ?>> getGreaterMapOrEqualSize(int target) {
        return map -> JMPredicate.getGreaterOrEqual(target).test(map.size());
    }

    public static Predicate<Object[]> getGreaterOrEqualLength(int target) {
        return array -> JMPredicate.getGreaterOrEqual(target).test(((Object[])array).length);
    }

    public static Predicate<Collection<?>> getLessSize(int target) {
        return collection -> JMPredicate.getLess(target).test(collection.size());
    }

    public static Predicate<Map<?, ?>> getLessMapSize(int target) {
        return map -> JMPredicate.getLess(target).test(map.size());
    }

    public static Predicate<Object[]> getLessLength(int target) {
        return array -> JMPredicate.getLess(target).test(((Object[])array).length);
    }

    public static Predicate<Collection<?>> getLessOrEqualSize(int target) {
        return collection -> JMPredicate.getLessOrEqual(target).test(collection.size());
    }

    public static Predicate<Map<?, ?>> getLessMapOrEqualSize(int target) {
        return map -> JMPredicate.getLessOrEqual(target).test(map.size());
    }

    public static Predicate<Object[]> getLessOrEqualLength(int target) {
        return array -> JMPredicate.getLessOrEqual(target).test(((Object[])array).length);
    }

    public static Predicate<String> getContains(CharSequence target) {
        return string -> string.contains(target);
    }

    public static Predicate<String> getEmpty() {
        return string -> string.isEmpty();
    }

    public static Predicate<String> getEndWith(String suffix) {
        return string -> string.endsWith(suffix);
    }

    public static Predicate<String> getStartWith(String prefix) {
        return string -> string.startsWith(prefix);
    }

    public static Predicate<String> getMatches(String regex) {
        return string -> string.matches(regex);
    }

    public static <T> Predicate<T> getNull() {
        return target -> target == null;
    }

    public static <T> Predicate<T> getNotNull() {
        return target -> target != null;
    }

    public static <T> Predicate<T> peekToRun(Runnable block) {
        return target -> JMLambda.getTrueAfterRunning(block);
    }

    public static <T> Predicate<T> peek(Consumer<T> consumer) {
        return target -> JMLambda.getTrueAfterRunning(() -> consumer.accept(target));
    }

    public static <T> Predicate<T> getEquals(T target2) {
        return target -> target.equals(target2);
    }
}

