/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.enums;

import java.text.DecimalFormat;
import java.util.stream.Stream;

public enum SimpleSIUnit {
    k(1),
    M(2),
    G(3),
    T(4),
    P(5),
    E(6);

    public static final int BASE_SIZE = 1024;
    private double min;
    private double max;

    private SimpleSIUnit(int power) {
        this.min = Math.pow(1024.0, power);
        this.max = this.min * 1024.0;
    }

    public static String findSIUnitAndConvertToString(long size, DecimalFormat decimalFormat, String suffix) {
        return Stream.of(SimpleSIUnit.values()).filter(si -> SimpleSIUnit.values()[0].min < (double)size).filter(si -> (double)size < si.max).map(si -> si.convertToString(size, decimalFormat, suffix)).findFirst().orElseGet(() -> decimalFormat.format(size) + suffix);
    }

    public double convert(Number number) {
        return number.doubleValue() / this.min;
    }

    public String appendSIUnit(String target, String suffix) {
        return target + " " + this.name() + suffix;
    }

    public String convertToString(Number size, String suffix) {
        return this.appendSIUnit(Double.toString(this.convert(size)), suffix);
    }

    public String convertToString(Number size, DecimalFormat decimalFormat, String suffix) {
        return this.appendSIUnit(decimalFormat.format(this.convert(size)), suffix);
    }
}

