/*
 * Decompiled with CFR 0.152.
 */
package io.colyseus.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class Http {
    private static final int HTTP_CONNECT_TIMEOUT = 10000;
    private static final int HTTP_READ_TIMEOUT = 10000;

    public static String request(String url) throws IOException, HttpException {
        return Http.request(url, "GET", null, null);
    }

    public static String request(String url, String method) throws IOException, HttpException {
        return Http.request(url, method, null, null);
    }

    public static String request(String url, String method, Map<String, String> httpHeaders) throws IOException, HttpException {
        return Http.request(url, method, httpHeaders, null);
    }

    public static String request(String url, String method, Map<String, String> httpHeaders, String body) throws IOException, HttpException {
        String responseLine;
        int code;
        HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
        con.setRequestMethod(method);
        if (httpHeaders != null) {
            for (Map.Entry<String, String> header : httpHeaders.entrySet()) {
                con.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        con.setConnectTimeout(10000);
        con.setReadTimeout(10000);
        if (body != null) {
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            byte[] input = body.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        InputStream is = (code = con.getResponseCode()) != 200 ? con.getErrorStream() : con.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        while ((responseLine = br.readLine()) != null) {
            sb.append(responseLine.trim());
        }
        String response = sb.toString();
        if (code != 200) {
            throw new HttpException(response, code);
        }
        return response;
    }

    public static class HttpException
    extends Exception {
        public int code;

        HttpException(String response, int code) {
            super(response);
            this.code = code;
        }
    }
}

