/*
 * Decompiled with CFR 0.152.
 */
package io.colyseus.serializer.schema;

import io.colyseus.serializer.schema.Change;
import io.colyseus.serializer.schema.Decoder;
import io.colyseus.serializer.schema.ISchemaCollection;
import io.colyseus.serializer.schema.Iterator;
import io.colyseus.serializer.schema.annotations.SchemaClass;
import io.colyseus.serializer.schema.annotations.SchemaField;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Schema {
    private HashMap<Integer, String> fieldsByIndex = new HashMap();
    private HashMap<String, String> fieldTypeNames = new HashMap();
    private HashMap<String, Class<?>> fieldTypes = new HashMap();
    private HashMap<String, String> fieldChildTypeNames = new HashMap();
    public onChange onChange;
    public onRemove onRemove;

    public Schema() {
        if (this.getClass().isAnnotationPresent(SchemaClass.class)) {
            for (Field field : this.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(SchemaField.class)) continue;
                String fieldName = field.getName();
                Class<?> fieldType = field.getType();
                String annotation = field.getAnnotation(SchemaField.class).value();
                String[] parts = annotation.split("/");
                int fieldIndex = Integer.parseInt(parts[0]);
                String schemaFieldTypeName = parts[1];
                this.fieldsByIndex.put(fieldIndex, fieldName);
                this.fieldTypeNames.put(fieldName, schemaFieldTypeName);
                this.fieldTypes.put(fieldName, fieldType);
                if (!schemaFieldTypeName.equals("array") && !schemaFieldTypeName.equals("map")) continue;
                this.fieldChildTypeNames.put(fieldName, parts[2]);
            }
        } else {
            throw new Error(this.getClass() + " does not have @SchemaClass annotation");
        }
    }

    public void decode(byte[] bytes) throws NullPointerException, ArrayIndexOutOfBoundsException, InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        this.decode(bytes, new Iterator(0));
    }

    public void decode(byte[] bytes, Iterator it) throws NullPointerException, ArrayIndexOutOfBoundsException, NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, InstantiationException {
        byte index;
        Decoder decode = Decoder.getInstance();
        ArrayList<Change> changes = new ArrayList<Change>();
        if (bytes[it.offset] == -43) {
            it.offset += 2;
        }
        int totalBytes = bytes.length;
        while (it.offset < totalBytes && (index = bytes[it.offset++]) != -63) {
            boolean hasChange;
            Object value;
            String field = this.fieldsByIndex.get(index);
            Class<?> fieldType = this.fieldTypes.get(field);
            String fieldTypeName = this.fieldTypeNames.get(field);
            String childPrimitiveType = this.fieldChildTypeNames.get(field);
            ArrayList change = null;
            switch (fieldTypeName) {
                case "ref": {
                    if (decode.nilCheck(bytes, it)) {
                        ++it.offset;
                        value = null;
                    } else {
                        value = this.thiz(field);
                        if (value == null) {
                            value = this.createTypeInstance(bytes, it, fieldType);
                        }
                        ((Schema)value).decode(bytes, it);
                    }
                    hasChange = true;
                    break;
                }
                case "array": {
                    int i;
                    change = new ArrayList();
                    ISchemaCollection<String, Schema> valueRef = (ArraySchema)this.thiz(field);
                    ISchemaCollection<String, Schema> currentValue = (ArraySchema)((ArraySchema)valueRef)._clone();
                    int newLength = (int)decode.decodeNumber(bytes, it);
                    int numChanges = Math.min((int)decode.decodeNumber(bytes, it), newLength);
                    hasChange = numChanges > 0;
                    boolean hasIndexChange = false;
                    if (((ArraySchema)currentValue).count() > newLength) {
                        List items = ((ArraySchema)currentValue).items;
                        for (int i2 = newLength; i2 < ((ArraySchema)currentValue).count(); ++i2) {
                            Object item = items.get(i2);
                            if (item instanceof Schema && ((Schema)item).onRemove != null) {
                                ((Schema)item).onRemove.onRemove();
                            }
                            ((ArraySchema)currentValue).invokeOnRemove((Schema)item, i2);
                        }
                        ArrayList newItems = new ArrayList();
                        for (i = 0; i < newLength; ++i) {
                            newItems.add(((ArraySchema)currentValue).get(i));
                        }
                        ((ArraySchema)currentValue).items = newItems;
                    }
                    for (int i3 = 0; i3 < numChanges; ++i3) {
                        boolean isNew;
                        int newIndex = (int)decode.decodeNumber(bytes, it);
                        int indexChangedFrom = -1;
                        if (decode.indexChangeCheck(bytes, it)) {
                            decode.decodeUint8(bytes, it);
                            indexChangedFrom = (int)decode.decodeNumber(bytes, it);
                            hasIndexChange = true;
                        }
                        boolean bl = isNew = !hasIndexChange && ((ArraySchema)currentValue).get(newIndex) == null || hasIndexChange && indexChangedFrom != -1;
                        if (((ArraySchema)currentValue).hasSchemaChild()) {
                            Schema item = isNew ? (Schema)this.createTypeInstance(bytes, it, ((ArraySchema)currentValue).getChildType()) : (indexChangedFrom != -1 ? (Schema)((ArraySchema)valueRef).get(indexChangedFrom) : (Schema)((ArraySchema)valueRef).get(newIndex));
                            if (item == null) {
                                item = (Schema)this.createTypeInstance(bytes, it, ((ArraySchema)currentValue).getChildType());
                                isNew = true;
                            }
                            if (decode.nilCheck(bytes, it)) {
                                ++it.offset;
                                if (item.onRemove != null) {
                                    item.onRemove.onRemove();
                                }
                                ((ArraySchema)valueRef).invokeOnRemove(item, newIndex);
                                continue;
                            }
                            item.decode(bytes, it);
                            ((ArraySchema)currentValue).set(newIndex, item);
                        } else {
                            ((ArraySchema)currentValue).set(newIndex, (Schema)decode.decodePrimitiveType(childPrimitiveType, bytes, it));
                        }
                        if (isNew) {
                            ((ArraySchema)currentValue).invokeOnAdd((Schema)((ArraySchema)currentValue).get(newIndex), newIndex);
                        } else {
                            ((ArraySchema)currentValue).invokeOnChange((Schema)((ArraySchema)currentValue).get(newIndex), newIndex);
                        }
                        change.add(((ArraySchema)currentValue).get(newIndex));
                    }
                    value = currentValue;
                    break;
                }
                case "map": {
                    int i;
                    ISchemaCollection<String, Schema> valueRef = (MapSchema)this.thiz(field);
                    ISchemaCollection<String, Schema> currentValue = (MapSchema)((MapSchema)valueRef)._clone();
                    int length = (int)decode.decodeNumber(bytes, it);
                    hasChange = length > 0;
                    boolean hasIndexChange = false;
                    Map items = ((MapSchema)currentValue).items;
                    Object[] keys = items.keySet().toArray();
                    String[] mapKeys = new String[items.size()];
                    for (i = 0; i < keys.length; ++i) {
                        mapKeys[i] = (String)keys[i];
                    }
                    for (i = 0; i < length && it.offset <= bytes.length && bytes[it.offset] != -63; ++i) {
                        boolean isNew;
                        String previousKey = null;
                        if (decode.indexChangeCheck(bytes, it)) {
                            ++it.offset;
                            previousKey = mapKeys[(int)decode.decodeNumber(bytes, it)];
                            hasIndexChange = true;
                        }
                        boolean hasMapIndex = decode.numberCheck(bytes, it);
                        boolean isSchemaType = ((MapSchema)currentValue).hasSchemaChild();
                        String newKey = hasMapIndex ? mapKeys[(int)decode.decodeNumber(bytes, it)] : decode.decodeString(bytes, it);
                        boolean bl = isNew = !hasIndexChange && ((MapSchema)valueRef).get(newKey) == null || hasIndexChange && previousKey == null && hasMapIndex;
                        Object item = isNew && isSchemaType ? this.createTypeInstance(bytes, it, ((MapSchema)currentValue).getChildType()) : (previousKey != null ? ((MapSchema)valueRef).get(previousKey) : ((MapSchema)valueRef).get(newKey));
                        if (decode.nilCheck(bytes, it)) {
                            ++it.offset;
                            if (item instanceof Schema && ((Schema)item).onRemove != null) {
                                ((Schema)item).onRemove.onRemove();
                            }
                            ((MapSchema)valueRef).invokeOnRemove((Schema)item, newKey);
                            items.remove(newKey);
                            continue;
                        }
                        if (!isSchemaType) {
                            ((MapSchema)currentValue).set(newKey, (Schema)decode.decodePrimitiveType(childPrimitiveType, bytes, it));
                        } else {
                            ((Schema)item).decode(bytes, it);
                            ((MapSchema)currentValue).set(newKey, (Schema)item);
                        }
                        if (isNew) {
                            ((MapSchema)currentValue).invokeOnAdd((Schema)((MapSchema)currentValue).get(newKey), newKey);
                            continue;
                        }
                        ((MapSchema)currentValue).invokeOnChange((Schema)((MapSchema)currentValue).get(newKey), newKey);
                    }
                    value = currentValue;
                    break;
                }
                default: {
                    value = decode.decodePrimitiveType(fieldTypeName, bytes, it);
                    hasChange = true;
                }
            }
            if (hasChange) {
                Change dataChange = new Change();
                dataChange.field = field;
                dataChange.value = change != null ? change : value;
                dataChange.previousValue = this.thiz(field);
                changes.add(dataChange);
            }
            Field f = this.getClass().getDeclaredField(field);
            f.setAccessible(true);
            f.set(this, value);
        }
        if (!changes.isEmpty() && this.onChange != null) {
            this.onChange.onChange(changes);
        }
    }

    public void triggerAll() {
        if (this.onChange == null) {
            return;
        }
        try {
            ArrayList<Change> changes = new ArrayList<Change>();
            for (String field : this.fieldsByIndex.values()) {
                Object value = this.thiz(field);
                if (value == null) continue;
                Change change = new Change();
                change.field = field;
                change.value = value;
                change.previousValue = null;
                changes.add(change);
            }
            this.onChange.onChange(changes);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected Object thiz(String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = this.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(this);
    }

    protected Object createTypeInstance(byte[] bytes, Iterator it, Class<?> type) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (bytes[it.offset] == -43) {
            ++it.offset;
            short typeId = Decoder.getInstance().decodeUint8(bytes, it);
            Type anotherType = Context.getInstance().get(typeId);
            return anotherType.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        Constructor<?> constructor = type.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }

    public Schema _clone() {
        return this;
    }

    public static class SPEC {
        public static final byte END_OF_STRUCTURE = -63;
        public static final byte NIL = -64;
        public static final byte INDEX_CHANGE = -44;
        public static final byte TYPE_ID = -43;
    }

    public static class Context {
        protected static Context instance = new Context();
        protected LinkedHashMap<Integer, Type> typeIds = new LinkedHashMap();

        public static Context getInstance() {
            return instance;
        }

        public Type get(int typeid) {
            return this.typeIds.get(typeid);
        }
    }

    @SchemaClass
    public static class SchemaReflection
    extends Schema {
        @SchemaField(value="0/array/SchemaReflectionType")
        public ArraySchema<SchemaReflectionType> types = new ArraySchema<SchemaReflectionType>(SchemaReflectionType.class);
        @SchemaField(value="1/uint8")
        public int rootType;
    }

    @SchemaClass
    public static class SchemaReflectionType
    extends Schema {
        @SchemaField(value="0/uint8")
        public int id;
        @SchemaField(value="1/array/SchemaReflectionField")
        public ArraySchema<SchemaReflectionField> fields = new ArraySchema<SchemaReflectionField>(SchemaReflectionField.class);
    }

    @SchemaClass
    public static class SchemaReflectionField
    extends Schema {
        @SchemaField(value="0/string")
        public String name;
        @SchemaField(value="1/string")
        public String type;
        @SchemaField(value="2/uint8")
        public int referencedType;
    }

    public static class MapSchema<T>
    implements ISchemaCollection<String, T> {
        private Class<T> childType;
        public Map<String, T> items = Collections.synchronizedMap(new LinkedHashMap());
        public onAddListener<T> onAdd;
        public onChangeListener<T> onChange;
        public onRemoveListener<T> onRemove;

        public MapSchema() {
        }

        public MapSchema(Class<T> childType) {
            this.childType = childType;
        }

        public MapSchema(Class<T> childType, Map<String, T> items) {
            this.childType = childType;
            this.items = items == null ? Collections.synchronizedMap(new LinkedHashMap()) : items;
        }

        @Override
        public ISchemaCollection _clone() {
            MapSchema<T> clone = new MapSchema<T>(this.childType, this.items);
            clone.onAdd = this.onAdd;
            clone.onChange = this.onChange;
            clone.onRemove = this.onRemove;
            return clone;
        }

        @Override
        public Class<?> getChildType() {
            return this.childType;
        }

        @Override
        public boolean hasSchemaChild() {
            if (this.childType == null) {
                return false;
            }
            return Schema.class.isAssignableFrom(this.childType);
        }

        @Override
        public T get(String key) {
            return this.items.get(key);
        }

        @Override
        public void set(String key, T item) {
            this.items.put(key, item);
        }

        public void clear() {
            this.items.clear();
        }

        public boolean contains(String key, T value) {
            T val = this.items.get(key);
            return val != null && val.equals(value);
        }

        public void remove(String key) {
            this.items.remove(key);
        }

        public Set<String> keys() {
            return this.items.keySet();
        }

        public Collection<T> values() {
            return this.items.values();
        }

        @Override
        public int count() {
            return this.items.size();
        }

        public boolean containsKey(String key) {
            return this.items.containsKey(key);
        }

        @Override
        public void invokeOnAdd(T item, String key) {
            if (this.onAdd != null) {
                this.onAdd.onAdd(item, key);
            }
        }

        @Override
        public void invokeOnChange(T item, String key) {
            if (this.onChange != null) {
                this.onChange.onChange(item, key);
            }
        }

        @Override
        public void invokeOnRemove(T item, String key) {
            if (this.onRemove != null) {
                this.onRemove.onRemove(item, key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void triggerAll() {
            if (this.onAdd == null) {
                return;
            }
            Map<String, T> map = this.items;
            synchronized (map) {
                for (String key : this.items.keySet()) {
                    this.onAdd.onAdd(this.items.get(key), key);
                }
            }
        }

        public static interface onRemoveListener<T> {
            public void onRemove(T var1, String var2);
        }

        public static interface onChangeListener<T> {
            public void onChange(T var1, String var2);
        }

        public static interface onAddListener<T> {
            public void onAdd(T var1, String var2);
        }
    }

    public static class ArraySchema<T>
    implements ISchemaCollection<Integer, T> {
        private Class<T> childType;
        public List<T> items = Collections.synchronizedList(new ArrayList());
        public onAddListener<T> onAdd;
        public onChangeListener<T> onChange;
        public onRemoveListener<T> onRemove;

        public ArraySchema() {
        }

        public ArraySchema(Class<T> childType) {
            this.childType = childType;
        }

        public ArraySchema(Class<T> childType, List<T> items) {
            this.childType = childType;
            this.items = items == null ? Collections.synchronizedList(new ArrayList()) : items;
        }

        @Override
        public ISchemaCollection _clone() {
            ArraySchema<T> clone = new ArraySchema<T>(this.childType, this.items);
            clone.onAdd = this.onAdd;
            clone.onChange = this.onChange;
            clone.onRemove = this.onRemove;
            return clone;
        }

        @Override
        public Class<?> getChildType() {
            return this.childType;
        }

        @Override
        public boolean hasSchemaChild() {
            if (this.childType == null) {
                return false;
            }
            return Schema.class.isAssignableFrom(this.childType);
        }

        @Override
        public int count() {
            return this.items.size();
        }

        @Override
        public void invokeOnAdd(T item, Integer index) {
            if (this.onAdd != null) {
                this.onAdd.onAdd(item, index);
            }
        }

        @Override
        public void invokeOnChange(T item, Integer index) {
            if (this.onChange != null) {
                this.onChange.onChange(item, index);
            }
        }

        @Override
        public void invokeOnRemove(T item, Integer index) {
            if (this.onRemove != null) {
                this.onRemove.onRemove(item, index);
            }
        }

        @Override
        public T get(Integer key) {
            if (key >= 0 && key < this.items.size()) {
                return this.items.get(key);
            }
            return null;
        }

        @Override
        public void set(Integer key, T item) {
            if (key < this.items.size()) {
                this.items.set(key, item);
            } else if (key.intValue() == this.items.size()) {
                this.items.add(item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void triggerAll() {
            if (this.onAdd == null) {
                return;
            }
            List<T> list = this.items;
            synchronized (list) {
                for (int i = 0; i < this.items.size(); ++i) {
                    this.onAdd.onAdd(this.items.get(i), i);
                }
            }
        }

        public static interface onRemoveListener<T> {
            public void onRemove(T var1, int var2);
        }

        public static interface onChangeListener<T> {
            public void onChange(T var1, int var2);
        }

        public static interface onAddListener<T> {
            public void onAdd(T var1, int var2);
        }
    }

    public static interface onRemove {
        public void onRemove();
    }

    public static interface onChange {
        public void onChange(List<Change> var1);
    }
}

