/*
 * Decompiled with CFR 0.152.
 */
package io.colyseus;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.colyseus.Client;
import io.colyseus.Connection;
import io.colyseus.serializer.SchemaSerializer;
import io.colyseus.serializer.schema.Schema;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class Room<T extends Schema> {
    public T state;
    private Class<Schema> stateType;
    private LinkedHashMap<String, Object> options;
    private String id;
    private String sessionId;
    private String name;
    private Client client;
    private List<Listener> listeners = new ArrayList<Listener>();
    private Connection connection;
    private byte[] _previousState;
    private ObjectMapper msgpackMapper;
    private SchemaSerializer<Schema> serializer;
    private int previousCode;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    LinkedHashMap<String, Object> getOptions() {
        return this.options;
    }

    public void setOptions(LinkedHashMap<String, Object> options) {
        this.options = options;
    }

    public void setConnection(LinkedHashMap<String, Object> options) {
        this.options = options;
    }

    Room(Class<Schema> type, Client client, String roomName, LinkedHashMap<String, Object> options) {
        this.stateType = type;
        this.client = client;
        this.name = roomName;
        this.options = options;
        this.msgpackMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        try {
            this.serializer = new SchemaSerializer<Schema>(this.stateType);
            this.state = this.serializer.state;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    void connect(String endpoint, Map<String, String> httpHeaders, int connectTimeout) throws URISyntaxException {
        this.connection = new Connection(new URI(endpoint), connectTimeout, httpHeaders, new Connection.Listener(){

            @Override
            public void onError(Exception e) {
                for (Listener listener : Room.this.listeners) {
                    if (listener == null) continue;
                    listener.onError(e);
                }
            }

            @Override
            public void onClose(int code, String reason, boolean remote) {
                if (code == 1002 && reason != null && reason.startsWith("Invalid status code received: 401")) {
                    for (Listener listener : Room.this.listeners) {
                        if (listener == null) continue;
                        listener.onError(new Exception(reason));
                    }
                }
                for (Listener listener : Room.this.listeners) {
                    if (listener == null) continue;
                    listener.onLeave();
                }
                Room.this.client.onRoomLeave(Room.this.id);
            }

            @Override
            public void onOpen() {
            }

            @Override
            public void onMessage(ByteBuffer buf) {
                Room.this.onMessageCallback(buf);
            }
        });
    }

    private void onMessageCallback(ByteBuffer buf) {
        try {
            if (this.previousCode == 0) {
                byte code = buf.get();
                if (code == 10) {
                    Object b;
                    byte[] bytes = new byte[buf.get()];
                    buf.get(bytes, 0, bytes.length);
                    this.sessionId = new String(bytes, StandardCharsets.UTF_8);
                    bytes = new byte[buf.get()];
                    buf.get(bytes, 0, bytes.length);
                    String serializerId = new String(bytes, StandardCharsets.UTF_8);
                    if (serializerId.equals("fossil-delta")) {
                        throw new Error("fossil-delta is not supported");
                    }
                    if (buf.hasRemaining()) {
                        b = new byte[buf.remaining()];
                        buf.get((byte[])b, 0, ((Object)b).length);
                        this.serializer.handshake((byte[])b);
                    }
                    b = this.listeners.iterator();
                    while (b.hasNext()) {
                        Listener listener = (Listener)b.next();
                        if (listener == null) continue;
                        listener.onJoin();
                    }
                } else if (code == 11) {
                    byte length = buf.get();
                    byte[] bytes = new byte[length];
                    buf.get(bytes, 0, length);
                    String message = new String(bytes, StandardCharsets.UTF_8);
                    for (Listener listener : this.listeners) {
                        if (listener == null) continue;
                        listener.onError(new Exception(message));
                    }
                } else if (code == 12) {
                    this.leave();
                } else {
                    this.previousCode = code;
                }
            } else {
                if (buf.hasRemaining()) {
                    if (this.previousCode == 14) {
                        byte[] bytes = new byte[buf.remaining()];
                        buf.get(bytes);
                        this.setState(bytes);
                    } else if (this.previousCode == 15) {
                        byte[] bytes = new byte[buf.remaining()];
                        buf.get(bytes);
                        this.patch(bytes);
                    } else if (this.previousCode == 13) {
                        byte[] bytes = new byte[buf.remaining()];
                        buf.get(bytes);
                        Object data = this.msgpackMapper.readValue(bytes, (TypeReference)new TypeReference<Object>(){});
                        for (Listener listener : this.listeners) {
                            if (listener == null) continue;
                            listener.onMessage(data);
                        }
                    }
                }
                this.previousCode = 0;
            }
        }
        catch (Exception e) {
            for (Listener listener : this.listeners) {
                if (listener == null) continue;
                listener.onError(e);
            }
        }
    }

    private void dispatchOnMessage(Object message) {
        for (Listener listener : this.listeners) {
            if (listener == null) continue;
            listener.onMessage(message);
        }
    }

    public void leave() {
        this.leave(true);
    }

    public void leave(boolean consented) {
        if (this.id != null) {
            if (consented) {
                this.connection.send(12);
            } else {
                this.connection.close();
            }
        } else {
            for (Listener listener : this.listeners) {
                if (listener == null) continue;
                listener.onLeave();
            }
        }
    }

    public void send(Object data) {
        if (this.connection != null) {
            this.connection.send(13, this.id, data);
        } else {
            for (Listener listener : this.listeners) {
                if (listener == null) continue;
                listener.onError(new Exception("send error: Room is created but not joined yet"));
            }
        }
    }

    public boolean hasJoined() {
        return this.sessionId != null;
    }

    private void setState(byte[] encodedState) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        this.serializer.setState(encodedState);
        for (Listener listener : this.listeners) {
            if (listener == null) continue;
            listener.onStateChange(((Schema)this.serializer.state)._clone(), true);
        }
    }

    private void patch(byte[] delta) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        this.serializer.patch(delta);
        for (Listener listener : this.listeners) {
            if (listener == null) continue;
            listener.onStateChange(this.serializer.state, false);
        }
    }

    public static abstract class Listener<T extends Schema> {
        protected Listener() {
        }

        protected void onLeave() {
        }

        protected void onError(Exception e) {
        }

        protected void onMessage(Object message) {
        }

        protected void onJoin() {
        }

        protected void onStateChange(T state, boolean isFirstState) {
        }
    }
}

