/*
 * Decompiled with CFR 0.152.
 */
package io.colyseus;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Map;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class Connection
extends WebSocketClient {
    private LinkedList<Object[]> _enqueuedCalls = new LinkedList();
    private Listener listener;
    private ObjectMapper msgpackMapper;

    Connection(URI uri, int connectTimeout, Map<String, String> httpHeaders, Listener listener) {
        super(uri, (Draft)new Draft_6455(), httpHeaders, connectTimeout);
        System.out.println("Connection()");
        System.out.println("url is " + uri);
        this.listener = listener;
        this.msgpackMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
        this.connect();
    }

    void send(Object ... data) {
        if (this.isOpen()) {
            try {
                this.send(this.msgpackMapper.writeValueAsBytes((Object)data));
            }
            catch (Exception e) {
                this.onError(e);
            }
        } else {
            this._enqueuedCalls.push(data);
        }
    }

    public void onOpen(ServerHandshake handshakedata) {
        if (this._enqueuedCalls.size() > 0) {
            for (Object[] objects : this._enqueuedCalls) {
                this.send(objects);
            }
            this._enqueuedCalls.clear();
        }
        if (this.listener != null) {
            this.listener.onOpen();
        }
    }

    public void onMessage(String message) {
    }

    public void onClose(int code, String reason, boolean remote) {
        if (this.listener != null) {
            this.listener.onClose(code, reason, remote);
        }
    }

    public void onError(Exception ex) {
        if (this.listener != null) {
            this.listener.onError(ex);
        }
    }

    public void onMessage(ByteBuffer buf) {
        if (this.listener != null) {
            this.listener.onMessage(buf);
        }
    }

    static interface Listener {
        public void onError(Exception var1);

        public void onClose(int var1, String var2, boolean var3);

        public void onOpen();

        public void onMessage(ByteBuffer var1);
    }
}

