/*
 * Decompiled with CFR 0.152.
 */
package io.colyseus;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Map;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.handshake.ServerHandshake;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class Connection
extends WebSocketClient {
    private LinkedList<Object[]> _enqueuedCalls = new LinkedList();
    private Listener listener;

    Connection(String url, int connectTimeout, Map<String, String> httpHeaders, Listener listener) throws URISyntaxException {
        super(new URI(url), (Draft)new Draft_6455(), httpHeaders, connectTimeout);
        this.listener = listener;
        this.connect();
    }

    void send(Object ... data) {
        if (this.isOpen()) {
            try {
                this.send(new ObjectMapper((JsonFactory)new MessagePackFactory()).writeValueAsBytes((Object)data));
            }
            catch (Exception e) {
                this.onError(e);
            }
        } else {
            this._enqueuedCalls.push(data);
        }
    }

    public void onOpen(ServerHandshake handshakedata) {
        if (this._enqueuedCalls.size() > 0) {
            for (Object[] objects : this._enqueuedCalls) {
                this.send(objects);
            }
            this._enqueuedCalls.clear();
        }
        if (this.listener != null) {
            this.listener.onOpen();
        }
    }

    public void onMessage(String message) {
    }

    public void onClose(int code, String reason, boolean remote) {
        if (this.listener != null) {
            this.listener.onClose(code, reason, remote);
        }
    }

    public void onError(Exception ex) {
        if (this.listener != null) {
            this.listener.onError(ex);
        }
    }

    public void onMessage(ByteBuffer buf) {
        if (this.listener != null) {
            byte[] bytes = new byte[buf.capacity()];
            buf.get(bytes, 0, bytes.length);
            this.listener.onMessage(bytes);
        }
    }

    static interface Listener {
        public void onError(Exception var1);

        public void onClose(int var1, String var2, boolean var3);

        public void onOpen();

        public void onMessage(byte[] var1);
    }
}

