/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.validation.zeebe;

import io.zeebe.model.bpmn.instance.Activity;
import io.zeebe.model.bpmn.instance.CallActivity;
import io.zeebe.model.bpmn.instance.MultiInstanceLoopCharacteristics;
import io.zeebe.model.bpmn.instance.ServiceTask;
import io.zeebe.model.bpmn.instance.zeebe.ZeebeCalledElement;
import io.zeebe.model.bpmn.instance.zeebe.ZeebeLoopCharacteristics;
import io.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import io.zeebe.model.bpmn.validation.zeebe.ActivityValidator;
import io.zeebe.model.bpmn.validation.zeebe.BoundaryEventValidator;
import io.zeebe.model.bpmn.validation.zeebe.DefinitionsValidator;
import io.zeebe.model.bpmn.validation.zeebe.EndEventValidator;
import io.zeebe.model.bpmn.validation.zeebe.ErrorEventDefinitionValidator;
import io.zeebe.model.bpmn.validation.zeebe.EventBasedGatewayValidator;
import io.zeebe.model.bpmn.validation.zeebe.EventDefinitionValidator;
import io.zeebe.model.bpmn.validation.zeebe.ExclusiveGatewayValidator;
import io.zeebe.model.bpmn.validation.zeebe.ExtensionElementsValidator;
import io.zeebe.model.bpmn.validation.zeebe.FlowElementValidator;
import io.zeebe.model.bpmn.validation.zeebe.FlowNodeValidator;
import io.zeebe.model.bpmn.validation.zeebe.IntermediateCatchEventValidator;
import io.zeebe.model.bpmn.validation.zeebe.MessageEventDefinitionValidator;
import io.zeebe.model.bpmn.validation.zeebe.MessageValidator;
import io.zeebe.model.bpmn.validation.zeebe.ProcessValidator;
import io.zeebe.model.bpmn.validation.zeebe.ReceiveTaskValidator;
import io.zeebe.model.bpmn.validation.zeebe.SequenceFlowValidator;
import io.zeebe.model.bpmn.validation.zeebe.StartEventValidator;
import io.zeebe.model.bpmn.validation.zeebe.SubProcessValidator;
import io.zeebe.model.bpmn.validation.zeebe.TimerEventDefinitionValidator;
import io.zeebe.model.bpmn.validation.zeebe.ZeebeCalledElementValidator;
import io.zeebe.model.bpmn.validation.zeebe.ZeebeFormDefinitionValidator;
import io.zeebe.model.bpmn.validation.zeebe.ZeebeLoopCharacteristicsValidator;
import io.zeebe.model.bpmn.validation.zeebe.ZeebeSubscriptionValidator;
import io.zeebe.model.bpmn.validation.zeebe.ZeebeTaskDefinitionValidator;
import io.zeebe.model.bpmn.validation.zeebe.ZeebeUserTaskFormValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;

public final class ZeebeDesignTimeValidators {
    public static final Collection<ModelElementValidator<?>> VALIDATORS;

    private ZeebeDesignTimeValidators() {
    }

    static {
        ArrayList<ModelElementValidator<Activity>> validators = new ArrayList<ModelElementValidator<Activity>>();
        validators.add(new ActivityValidator());
        validators.add(new BoundaryEventValidator());
        validators.add(ExtensionElementsValidator.verifyThat(CallActivity.class).hasSingleExtensionElement(ZeebeCalledElement.class, "calledElement"));
        validators.add(new DefinitionsValidator());
        validators.add(new EndEventValidator());
        validators.add(new EventDefinitionValidator());
        validators.add(new EventBasedGatewayValidator());
        validators.add(new ErrorEventDefinitionValidator());
        validators.add(new ExclusiveGatewayValidator());
        validators.add(new FlowElementValidator());
        validators.add(new FlowNodeValidator());
        validators.add(new IntermediateCatchEventValidator());
        validators.add(new MessageEventDefinitionValidator());
        validators.add(new MessageValidator());
        validators.add(ExtensionElementsValidator.verifyThat(MultiInstanceLoopCharacteristics.class).hasSingleExtensionElement(ZeebeLoopCharacteristics.class, "loopCharacteristics"));
        validators.add(new ProcessValidator());
        validators.add(new SequenceFlowValidator());
        validators.add(ExtensionElementsValidator.verifyThat(ServiceTask.class).hasSingleExtensionElement(ZeebeTaskDefinition.class, "taskDefinition"));
        validators.add(new ReceiveTaskValidator());
        validators.add(new StartEventValidator());
        validators.add(new SubProcessValidator());
        validators.add(new TimerEventDefinitionValidator());
        validators.add(new ZeebeCalledElementValidator());
        validators.add(new ZeebeLoopCharacteristicsValidator());
        validators.add(new ZeebeTaskDefinitionValidator());
        validators.add(new ZeebeSubscriptionValidator());
        validators.add(new ZeebeFormDefinitionValidator());
        validators.add(new ZeebeUserTaskFormValidator());
        VALIDATORS = Collections.unmodifiableList(validators);
    }
}

