/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.validation.zeebe;

import io.zeebe.model.bpmn.instance.TimeCycle;
import io.zeebe.model.bpmn.instance.TimeDate;
import io.zeebe.model.bpmn.instance.TimeDuration;
import io.zeebe.model.bpmn.instance.TimerEventDefinition;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class TimerEventDefinitionValidator
implements ModelElementValidator<TimerEventDefinition> {
    @Override
    public Class<TimerEventDefinition> getElementType() {
        return TimerEventDefinition.class;
    }

    @Override
    public void validate(TimerEventDefinition element, ValidationResultCollector validationResultCollector) {
        TimeDuration timeDuration = element.getTimeDuration();
        TimeCycle timeCycle = element.getTimeCycle();
        TimeDate timeDate = element.getTimeDate();
        int definitionsCount = 0;
        if (timeDate != null) {
            ++definitionsCount;
        }
        if (timeDuration != null) {
            ++definitionsCount;
        }
        if (timeCycle != null) {
            ++definitionsCount;
        }
        if (definitionsCount != 1) {
            validationResultCollector.addError(0, "Must be exactly one type of timer: timeDuration, timeDate or timeCycle");
        }
    }
}

