/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.validation;

import io.zeebe.model.bpmn.instance.BpmnModelElementInstance;
import io.zeebe.model.bpmn.traversal.TypeHierarchyVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.camunda.bpm.model.xml.impl.validation.ValidationResultsCollectorImpl;
import org.camunda.bpm.model.xml.type.ModelElementType;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResults;

public class ValidationVisitor
extends TypeHierarchyVisitor {
    private final Map<Class, List<ModelElementValidator>> validators;
    private ValidationResultsCollectorImpl resultCollector;

    public ValidationVisitor(Collection<ModelElementValidator<?>> validators) {
        this.validators = validators.stream().collect(Collectors.groupingBy(ModelElementValidator::getElementType));
        this.resultCollector = new ValidationResultsCollectorImpl();
    }

    @Override
    protected void visit(ModelElementType implementedType, BpmnModelElementInstance instance) {
        this.resultCollector.setCurrentElement(instance);
        this.validators.getOrDefault(implementedType.getInstanceType(), Collections.emptyList()).forEach(validator -> validator.validate(instance, this.resultCollector));
    }

    public void reset() {
        this.resultCollector = new ValidationResultsCollectorImpl();
    }

    public ValidationResults getValidationResult() {
        return this.resultCollector.getResults();
    }
}

