/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.example.process;

import io.zeebe.client.ZeebeClient;
import io.zeebe.client.ZeebeClientBuilder;
import io.zeebe.client.api.response.ProcessInstanceResult;
import java.time.Duration;
import java.util.Map;

public class ProcessInstanceWithResultCreator {
    public static void main(String[] args) {
        String defaultAddress = "localhost:26500";
        String envVarAddress = System.getenv("ZEEBE_ADDRESS");
        ZeebeClientBuilder clientBuilder = envVarAddress != null ? ZeebeClient.newClientBuilder().gatewayAddress(envVarAddress) : ZeebeClient.newClientBuilder().gatewayAddress("localhost:26500").usePlaintext();
        String bpmnProcessId = "demoProcessSingleTask";
        try (ZeebeClient client = clientBuilder.build();){
            ProcessInstanceWithResultCreator.openJobWorker(client);
            System.out.println("Creating process instance");
            ProcessInstanceResult processInstanceResult = (ProcessInstanceResult)client.newCreateInstanceCommand().bpmnProcessId("demoProcessSingleTask").latestVersion().withResult().send().join();
            System.out.println("Process instance created with key: " + processInstanceResult.getProcessInstanceKey() + " and completed with results: " + processInstanceResult.getVariables());
        }
    }

    private static void openJobWorker(ZeebeClient client) {
        client.newWorker().jobType("foo").handler((jobClient, job) -> jobClient.newCompleteCommand(job.getKey()).variables(Map.of("job", job.getKey())).send()).timeout(Duration.ofSeconds(10L)).open();
    }
}

