/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.example.process;

import io.zeebe.client.ZeebeClient;
import io.zeebe.client.ZeebeClientBuilder;
import io.zeebe.client.api.response.ProcessInstanceEvent;

public final class ProcessInstanceCreator {
    public static void main(String[] args) {
        String defaultAddress = "localhost:26500";
        String envVarAddress = System.getenv("ZEEBE_ADDRESS");
        ZeebeClientBuilder clientBuilder = envVarAddress != null ? ZeebeClient.newClientBuilder().gatewayAddress(envVarAddress) : ZeebeClient.newClientBuilder().gatewayAddress("localhost:26500").usePlaintext();
        String bpmnProcessId = "demoProcess";
        try (ZeebeClient client = clientBuilder.build();){
            System.out.println("Creating process instance");
            ProcessInstanceEvent processInstanceEvent = (ProcessInstanceEvent)client.newCreateInstanceCommand().bpmnProcessId("demoProcess").latestVersion().send().join();
            System.out.println("Process instance created with key: " + processInstanceEvent.getProcessInstanceKey());
        }
    }
}

