/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.example.process;

import io.zeebe.client.ZeebeClient;
import io.zeebe.client.ZeebeClientBuilder;
import io.zeebe.client.api.ZeebeFuture;

public final class NonBlockingProcessInstanceCreator {
    public static void main(String[] args) {
        String defaultAddress = "localhost:26500";
        String envVarAddress = System.getenv("ZEEBE_ADDRESS");
        ZeebeClientBuilder clientBuilder = envVarAddress != null ? ZeebeClient.newClientBuilder().gatewayAddress(envVarAddress) : ZeebeClient.newClientBuilder().gatewayAddress("localhost:26500").usePlaintext();
        int numberOfInstances = 100000;
        String bpmnProcessId = "demoProcess";
        try (ZeebeClient client = clientBuilder.build();){
            System.out.println("Creating 100000 process instances");
            long startTime = System.currentTimeMillis();
            for (long instancesCreating = 0L; instancesCreating < 100000L; ++instancesCreating) {
                ZeebeFuture future = client.newCreateInstanceCommand().bpmnProcessId("demoProcess").latestVersion().send();
            }
            client.newCreateInstanceCommand().bpmnProcessId("demoProcess").latestVersion().send().join();
            System.out.println("Took: " + (System.currentTimeMillis() - startTime));
        }
    }
}

