/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.example.job;

import io.zeebe.client.ZeebeClient;
import io.zeebe.client.ZeebeClientBuilder;
import io.zeebe.client.api.response.ActivatedJob;
import io.zeebe.client.api.worker.JobClient;
import io.zeebe.client.api.worker.JobHandler;
import io.zeebe.client.api.worker.JobWorker;
import java.time.Duration;
import java.util.Scanner;

public final class JobWorkerCreator {
    public static void main(String[] args) {
        String defaultAddress = "localhost:26500";
        String envVarAddress = System.getenv("ZEEBE_ADDRESS");
        ZeebeClientBuilder clientBuilder = envVarAddress != null ? ZeebeClient.newClientBuilder().gatewayAddress(envVarAddress) : ZeebeClient.newClientBuilder().gatewayAddress("localhost:26500").usePlaintext();
        String jobType = "foo";
        try (ZeebeClient client = clientBuilder.build();){
            System.out.println("Opening job worker.");
            try (JobWorker workerRegistration = client.newWorker().jobType("foo").handler(new ExampleJobHandler()).timeout(Duration.ofSeconds(10L)).open();){
                System.out.println("Job worker opened and receiving jobs.");
                JobWorkerCreator.waitUntilSystemInput("exit");
            }
        }
    }

    private static void waitUntilSystemInput(String exitCode) {
        try (Scanner scanner = new Scanner(System.in);){
            while (scanner.hasNextLine()) {
                String nextLine = scanner.nextLine();
                if (!nextLine.contains(exitCode)) continue;
                return;
            }
        }
    }

    private static class ExampleJobHandler
    implements JobHandler {
        private ExampleJobHandler() {
        }

        @Override
        public void handle(JobClient client, ActivatedJob job) {
            System.out.println(job);
            client.newCompleteCommand(job.getKey()).send().join();
        }
    }
}

