/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.example.data;

import io.zeebe.client.ZeebeClient;
import io.zeebe.client.ZeebeClientBuilder;
import io.zeebe.client.api.response.ActivatedJob;
import io.zeebe.client.api.worker.JobClient;
import io.zeebe.client.api.worker.JobHandler;
import java.util.Scanner;

public final class HandleVariablesAsPojo {
    public static void main(String[] args) {
        String defaultAddress = "localhost:26500";
        String envVarAddress = System.getenv("ZEEBE_ADDRESS");
        ZeebeClientBuilder clientBuilder = envVarAddress != null ? ZeebeClient.newClientBuilder().gatewayAddress(envVarAddress) : ZeebeClient.newClientBuilder().gatewayAddress("localhost:26500").usePlaintext();
        try (ZeebeClient client = clientBuilder.build();){
            Order order = new Order();
            order.setOrderId(31243L);
            client.newCreateInstanceCommand().bpmnProcessId("demoProcess").latestVersion().variables(order).send().join();
            client.newWorker().jobType("foo").handler(new DemoJobHandler()).open();
            HandleVariablesAsPojo.waitUntilSystemInput("exit");
        }
    }

    private static void waitUntilSystemInput(String exitCode) {
        try (Scanner scanner = new Scanner(System.in);){
            while (scanner.hasNextLine()) {
                String nextLine = scanner.nextLine();
                if (!nextLine.contains(exitCode)) continue;
                return;
            }
        }
    }

    private static class DemoJobHandler
    implements JobHandler {
        private DemoJobHandler() {
        }

        @Override
        public void handle(JobClient client, ActivatedJob job) {
            Order order = job.getVariablesAsType(Order.class);
            System.out.println("new job with orderId: " + order.getOrderId());
            order.setTotalPrice(46.5);
            client.newCompleteCommand(job.getKey()).variables(order).send();
        }
    }

    public static class Order {
        private long orderId;
        private double totalPrice;

        public long getOrderId() {
            return this.orderId;
        }

        public void setOrderId(long orderId) {
            this.orderId = orderId;
        }

        public double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(double totalPrice) {
            this.totalPrice = totalPrice;
        }
    }
}

